/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.AssertLegal;
import io.fluxcapacitor.javaclient.modeling.DeserializingMessageWithEntity;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.MessageWithEntity;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.Apply;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.InterceptApply;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public class DefaultEntityHelper
implements EntityHelper {
    private final Function<Class<?>, HandlerMatcher<Object, HasMessage>> interceptMatchers = ObjectUtils.memoize(type2 -> HandlerInspector.inspect(type2, parameterResolvers, InterceptApply.class));
    private final Function<Class<?>, HandlerMatcher<Object, DeserializingMessage>> applyMatchers = ObjectUtils.memoize(type2 -> HandlerInspector.inspect(type2, parameterResolvers, Apply.class));
    private final Function<Class<?>, HandlerMatcher<Object, HasMessage>> assertLegalMatchers = ObjectUtils.memoize(type2 -> HandlerInspector.inspect(type2, parameterResolvers, HandlerConfiguration.builder().methodAnnotation(AssertLegal.class).invokeMultipleMethods(true).build()));

    public DefaultEntityHelper(List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
    }

    @Override
    public Stream<?> intercept(Object value, Entity<?> entity) {
        MessageWithEntity m = new MessageWithEntity(value, entity);
        return this.interceptMatchers.apply(m.getPayloadClass()).findInvoker(m.getPayload(), m).map(i -> ObjectUtils.asStream(i.invoke()).flatMap(v -> Objects.equals(v, value) ? Stream.of(v) : this.intercept(v, entity))).orElseGet(() -> Stream.of(value));
    }

    @Override
    public Optional<HandlerInvoker> applyInvoker(DeserializingMessage event, final Entity<?> entity) {
        final DeserializingMessageWithEntity message = new DeserializingMessageWithEntity(event, entity);
        Class<?> entityType = entity.type();
        return this.applyMatchers.apply(entityType).findInvoker(entity.get(), message).or(() -> this.applyMatchers.apply(message.getPayloadClass()).findInvoker(message.getPayload(), message).filter(i -> {
            if (i.getMethod() instanceof Method) {
                Class<?> returnType = ((Method)i.getMethod()).getReturnType();
                return entityType.isAssignableFrom(returnType) || returnType.isAssignableFrom(entityType) || returnType.equals(Void.TYPE);
            }
            return false;
        })).map(i -> new HandlerInvoker.DelegatingHandlerInvoker((HandlerInvoker)i){

            @Override
            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                return message.apply(m -> {
                    boolean wasApplying = Entity.isApplying();
                    try {
                        Entity.applying.set(true);
                        Object result2 = this.delegate.invoke();
                        if (result2 == null && !this.delegate.expectResult()) {
                            Object t = entity.get();
                            return t;
                        }
                        Object object = result2;
                        return object;
                    }
                    finally {
                        Entity.applying.set(wasApplying);
                    }
                });
            }
        });
    }

    @Override
    public <E extends Exception> void assertLegal(Object value, Entity<?> entity) throws E {
        this.assertLegal(value, entity, false);
        Invocation.whenHandlerCompletes((r, e) -> {
            if (e == null) {
                this.assertLegal(value, entity, true);
            }
        });
    }

    private void assertLegal(Object value, Entity<?> entity, boolean afterHandler) {
        if (value == null) {
            return;
        }
        Object payload = value instanceof HasMessage ? ((HasMessage)value).getPayload() : value;
        this.assertLegalValue(payload.getClass(), payload, value, entity, afterHandler);
        entity.possibleTargets(payload).forEach(e -> this.assertLegalValue(payload.getClass(), payload, value, (Entity<?>)e, afterHandler));
        this.assertLegalValue(entity.type(), entity.get(), value, entity, afterHandler);
        entity.possibleTargets(payload).forEach(e -> this.assertLegalValue(e.type(), e.get(), value, (Entity<?>)e, afterHandler));
    }

    private void assertLegalValue(Class<?> targetType, Object target, Object value, Entity<?> entity, boolean afterHandler) {
        if (value == null) {
            return;
        }
        MessageWithEntity message = new MessageWithEntity(value, entity);
        HashSet additionalProperties = new HashSet(ReflectionUtils.getAnnotatedPropertyValues(target, AssertLegal.class));
        this.assertLegalMatchers.apply(targetType).findInvoker(target, message).filter(i -> ReflectionUtils.getAnnotation(i.getMethod(), AssertLegal.class).map(a -> a.afterHandler() == afterHandler).orElse(false)).ifPresent(s -> {
            Object additionalObject = s.invoke();
            if (additionalObject instanceof Collection) {
                additionalProperties.addAll((Collection)additionalObject);
            } else {
                additionalProperties.add(additionalObject);
            }
        });
        additionalProperties.stream().filter(Objects::nonNull).forEach(p -> this.assertLegalValue(p.getClass(), p, value, entity, afterHandler));
    }

    @Override
    public <E extends Exception> Optional<E> checkLegality(Object value, Entity<?> entity) {
        try {
            this.assertLegal(value, entity);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    @Override
    public boolean isLegal(Object value, Entity<?> entity) {
        return this.checkLegality(value, entity).isEmpty();
    }
}

