/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.api.HasMetadata;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.ReadOnlyEntity;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Entity<T> {
    public static final ThreadLocal<Boolean> loading = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> applying = ThreadLocal.withInitial(() -> false);
    public static final String AGGREGATE_ID_METADATA_KEY = "$aggregateId";
    public static final String AGGREGATE_TYPE_METADATA_KEY = "$aggregateType";
    public static final String AGGREGATE_SN_METADATA_KEY = "$sequenceNumber";

    public static boolean isLoading() {
        return loading.get();
    }

    public static boolean isApplying() {
        return applying.get();
    }

    public static String getAggregateId(HasMetadata message) {
        return message.getMetadata().get(AGGREGATE_ID_METADATA_KEY);
    }

    public static Class<?> getAggregateType(HasMetadata message) {
        return Optional.ofNullable(message.getMetadata().get(AGGREGATE_TYPE_METADATA_KEY)).map(c -> {
            try {
                return ReflectionUtils.classForName(c);
            }
            catch (Exception ignored) {
                return null;
            }
        }).orElse(null);
    }

    public static Long getSequenceNumber(HasMetadata message) {
        return Optional.ofNullable(message.getMetadata().get(AGGREGATE_SN_METADATA_KEY)).map(Long::parseLong).orElse(null);
    }

    public Object id();

    public Class<T> type();

    public T get();

    default public Entity<T> ifPresent(UnaryOperator<Entity<T>> action) {
        if (this.get() == null) {
            return this;
        }
        return (Entity)action.apply(this);
    }

    default public <U> Optional<U> mapIfPresent(Function<Entity<T>, U> action) {
        if (this.get() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(action.apply(this));
    }

    public String idProperty();

    public Entity<?> parent();

    default public Entity<?> root() {
        return Optional.ofNullable(this.parent()).map(Entity::root).orElse(this);
    }

    default public String lastEventId() {
        return this.root().lastEventId();
    }

    default public Long lastEventIndex() {
        return this.root().lastEventIndex();
    }

    default public Instant timestamp() {
        return this.root().timestamp();
    }

    default public long sequenceNumber() {
        return this.root().sequenceNumber();
    }

    default public Entity<T> previous() {
        return this.root().previous().allEntities().filter(e -> Objects.equals(e.id(), this.id()) && Objects.equals(e.type(), this.type())).findFirst().orElse(null);
    }

    default public Entity<T> playBackToEvent(String eventId) {
        return this.playBackToCondition(aggregate -> Objects.equals(eventId, aggregate.lastEventId())).orElseThrow(() -> new IllegalStateException(String.format("Could not load aggregate %s of type %s for event %s. Aggregate (%s) started at event %s", this.id(), this.type().getSimpleName(), eventId, this, this.lastEventId())));
    }

    default public Optional<Entity<T>> playBackToCondition(Predicate<Entity<T>> condition) {
        Entity<T> result2;
        for (result2 = this; result2 != null && !condition.test(result2); result2 = result2.previous()) {
        }
        return Optional.ofNullable(result2);
    }

    public Collection<? extends Entity<?>> entities();

    default public Stream<Entity<?>> allEntities() {
        return Stream.concat(Stream.of(this), this.entities().stream().flatMap(Entity::allEntities));
    }

    default public Optional<Entity<?>> getEntity(Object entityId) {
        return this.allEntities().filter(e -> entityId != null && entityId.equals(e.id())).findFirst();
    }

    default public Entity<T> makeReadOnly() {
        if (this instanceof ReadOnlyEntity) {
            return this;
        }
        return new ReadOnlyEntity(this);
    }

    default public Set<Relationship> relationships() {
        String id = this.id().toString();
        String type2 = this.type().getName();
        return this.get() == null ? Collections.emptySet() : this.allEntities().map(Entity::id).filter(Objects::nonNull).map(entityId -> Relationship.builder().entityId(entityId.toString()).aggregateType(type2).aggregateId(id).build()).collect(Collectors.toSet());
    }

    default public Set<Relationship> associations(Entity<?> previous) {
        HashSet<Relationship> result2 = new HashSet<Relationship>(this.relationships());
        result2.removeAll(previous.relationships());
        return result2;
    }

    default public Set<Relationship> dissociations(Entity<?> previous) {
        HashSet<Relationship> result2 = new HashSet<Relationship>(previous.relationships());
        result2.removeAll(this.relationships());
        return result2;
    }

    public Entity<T> update(UnaryOperator<T> var1);

    default public Entity<T> apply(Object ... events) {
        return this.apply(List.of(events));
    }

    default public Entity<T> apply(Collection<?> events) {
        Entity<T> result2 = this;
        for (Object event : events) {
            result2 = result2.apply(event);
        }
        return result2;
    }

    default public Entity<T> apply(Object event) {
        if (event instanceof DeserializingMessage) {
            return this.apply(((DeserializingMessage)event).toMessage());
        }
        return this.apply(Message.asMessage(event));
    }

    default public Entity<T> apply(Object event, Metadata metadata2) {
        return this.apply(new Message(event, metadata2));
    }

    public Entity<T> apply(Message var1);

    public <E extends Exception> Entity<T> assertLegal(Object var1) throws E;

    default public Entity<T> assertAndApply(Object payloadOrMessage) {
        return this.assertLegal(payloadOrMessage).apply(payloadOrMessage);
    }

    default public Entity<T> assertAndApply(Object payload, Metadata metadata2) {
        return this.assertAndApply(new Message(payload, metadata2));
    }

    default public <E extends Exception> Entity<T> assertThat(Validator<T, E> validator) throws E {
        validator.validate(this.get());
        return this;
    }

    default public <E extends Exception> Entity<T> ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        if (!check.test(this.get())) {
            throw (Exception)errorProvider.apply(this.get());
        }
        return this;
    }

    default public Iterable<Entity<?>> possibleTargets(Object payload) {
        if (payload != null) {
            for (Entity<?> e : this.entities()) {
                if (!e.isPossibleTarget(payload)) continue;
                return List.of(e);
            }
        }
        return Collections.emptyList();
    }

    private boolean isPossibleTarget(Object message) {
        Object payload;
        if (message == null) {
            return false;
        }
        for (Entity<?> e : this.entities()) {
            if (!e.isPossibleTarget(message)) continue;
            return true;
        }
        String idProperty = this.idProperty();
        Object id = this.id();
        if (idProperty == null) {
            return true;
        }
        if (id == null && this.get() != null) {
            return false;
        }
        Object object = payload = message instanceof Message ? ((Message)message).getPayload() : message;
        if (id == null) {
            return ReflectionUtils.hasProperty(idProperty, payload);
        }
        return ReflectionUtils.readProperty(idProperty, payload).or(() -> ReflectionUtils.getAnnotatedPropertyValue(payload, RoutingKey.class)).map(id::equals).orElse(false);
    }

    @FunctionalInterface
    public static interface Validator<T, E extends Exception> {
        public void validate(T var1) throws E;
    }
}

