/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.AnnotatedEntityHolder;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.Member;
import java.beans.ConstructorProperties;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableEntity<T>
implements Entity<T> {
    private static final Logger log = LoggerFactory.getLogger(ImmutableEntity.class);
    @JsonProperty
    private final Object id;
    @JsonProperty
    private final Class<T> type;
    @JsonProperty
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
    private final T value;
    @JsonProperty
    private final String idProperty;
    private final transient Entity<?> parent;
    private final transient AnnotatedEntityHolder holder;
    private final transient EntityHelper entityHelper;
    private final transient Serializer serializer;
    private final AtomicReference<Object> entities = new AtomicReference();

    @Override
    public Class<T> type() {
        return this.value == null ? this.type : this.value.getClass();
    }

    @Override
    public T get() {
        return this.value;
    }

    private Collection<? extends ImmutableEntity<?>> computeEntities() {
        Class<Object> type2 = this.value == null ? this.type() : this.value.getClass();
        ArrayList result2 = new ArrayList();
        for (AccessibleObject accessibleObject : ReflectionUtils.getAnnotatedProperties(type2, Member.class)) {
            result2.addAll(AnnotatedEntityHolder.getEntityHolder(type2, accessibleObject, this.entityHelper, this.serializer).getEntities(this).collect(Collectors.toList()));
        }
        return result2;
    }

    @Override
    public Entity<T> update(UnaryOperator<T> function) {
        Object after = ((ImmutableEntityBuilder)this.toBuilder().value(function.apply(this.get()))).build();
        if (this.parent == null) {
            return after;
        }
        return this.parent.update(p -> this.holder.updateOwner(p, this, (Entity<?>)after));
    }

    @Override
    public ImmutableEntity<T> apply(Message message) {
        return this.apply(new DeserializingMessage(message.serialize(this.serializer), type2 -> this.serializer.convert(message.getPayload(), type2), MessageType.EVENT));
    }

    @Override
    public <E extends Exception> Entity<T> assertLegal(Object command) throws E {
        this.entityHelper.assertLegal(command, this.root());
        return this;
    }

    ImmutableEntity<T> apply(DeserializingMessage message) {
        Optional<HandlerInvoker> invoker = this.entityHelper.applyInvoker(message, this);
        if (invoker.isPresent()) {
            return ((ImmutableEntityBuilder)this.toBuilder().value(invoker.get().invoke())).build();
        }
        ImmutableEntity<Object> result2 = this;
        Object payload = message.getPayload();
        for (Entity<?> entity : result2.possibleTargets(payload)) {
            ImmutableEntity immutableEntity = (ImmutableEntity)entity;
            ImmutableEntity<T> updated = immutableEntity.apply(message);
            if (immutableEntity.get() == updated.get()) continue;
            result2 = ((ImmutableEntityBuilder)result2.toBuilder().value(immutableEntity.holder().updateOwner(result2.get(), entity, updated))).build();
        }
        return result2;
    }

    protected ImmutableEntity(ImmutableEntityBuilder<T, ?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.value = b.value;
        this.idProperty = b.idProperty;
        this.parent = b.parent;
        this.holder = b.holder;
        this.entityHelper = b.entityHelper;
        this.serializer = b.serializer;
    }

    public static <T> ImmutableEntityBuilder<T, ?, ?> builder() {
        return new ImmutableEntityBuilderImpl();
    }

    public ImmutableEntityBuilder<T, ?, ?> toBuilder() {
        return new ImmutableEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public Object id() {
        return this.id;
    }

    public T value() {
        return this.value;
    }

    @Override
    public String idProperty() {
        return this.idProperty;
    }

    @Override
    public Entity<?> parent() {
        return this.parent;
    }

    public AnnotatedEntityHolder holder() {
        return this.holder;
    }

    public EntityHelper entityHelper() {
        return this.entityHelper;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableEntity)) {
            return false;
        }
        ImmutableEntity other = (ImmutableEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$id = this.id();
        Object other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Class<T> this$type = this.type();
        Class<T> other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$value = this.value();
        T other$value = other.value();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$idProperty = this.idProperty();
        String other$idProperty = other.idProperty();
        return !(this$idProperty == null ? other$idProperty != null : !this$idProperty.equals(other$idProperty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImmutableEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Object $id = this.id();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        Class<T> $type = this.type();
        result2 = result2 * 59 + ($type == null ? 43 : $type.hashCode());
        T $value = this.value();
        result2 = result2 * 59 + ($value == null ? 43 : $value.hashCode());
        String $idProperty = this.idProperty();
        result2 = result2 * 59 + ($idProperty == null ? 43 : $idProperty.hashCode());
        return result2;
    }

    public String toString() {
        return "ImmutableEntity(id=" + this.id() + ", type=" + this.type() + ", idProperty=" + this.idProperty() + ")";
    }

    @ConstructorProperties(value={"id", "type", "value", "idProperty", "parent", "holder", "entityHelper", "serializer"})
    public ImmutableEntity(Object id, Class<T> type2, T value, String idProperty, Entity<?> parent, AnnotatedEntityHolder holder, EntityHelper entityHelper, Serializer serializer) {
        this.id = id;
        this.type = type2;
        this.value = value;
        this.idProperty = idProperty;
        this.parent = parent;
        this.holder = holder;
        this.entityHelper = entityHelper;
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends Entity<?>> entities() {
        Object value = this.entities.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.entities;
            synchronized (atomicReference) {
                value = this.entities.get();
                if (value == null) {
                    Collection<ImmutableEntity<?>> actualValue = this.computeEntities();
                    value = actualValue == null ? this.entities : actualValue;
                    this.entities.set(value);
                }
            }
        }
        return (Collection)(value == this.entities ? null : value);
    }

    public static abstract class ImmutableEntityBuilder<T, C extends ImmutableEntity<T>, B extends ImmutableEntityBuilder<T, C, B>> {
        private Object id;
        private Class<T> type;
        private T value;
        private String idProperty;
        private Entity<?> parent;
        private AnnotatedEntityHolder holder;
        private EntityHelper entityHelper;
        private Serializer serializer;

        protected B $fillValuesFrom(C instance) {
            ImmutableEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(ImmutableEntity<T> instance, ImmutableEntityBuilder<T, ?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.value(instance.value);
            b.idProperty(instance.idProperty);
            b.parent(instance.parent);
            b.holder(instance.holder);
            b.entityHelper(instance.entityHelper);
            b.serializer(instance.serializer);
        }

        protected abstract B self();

        public abstract C build();

        @JsonProperty
        public B id(Object id) {
            this.id = id;
            return this.self();
        }

        @JsonProperty
        public B type(Class<T> type2) {
            this.type = type2;
            return this.self();
        }

        @JsonProperty
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
        public B value(T value) {
            this.value = value;
            return this.self();
        }

        @JsonProperty
        public B idProperty(String idProperty) {
            this.idProperty = idProperty;
            return this.self();
        }

        public B parent(Entity<?> parent) {
            this.parent = parent;
            return this.self();
        }

        public B holder(AnnotatedEntityHolder holder) {
            this.holder = holder;
            return this.self();
        }

        public B entityHelper(EntityHelper entityHelper) {
            this.entityHelper = entityHelper;
            return this.self();
        }

        public B serializer(Serializer serializer) {
            this.serializer = serializer;
            return this.self();
        }

        public String toString() {
            return "ImmutableEntity.ImmutableEntityBuilder(id=" + this.id + ", type=" + this.type + ", value=" + this.value + ", idProperty=" + this.idProperty + ", parent=" + this.parent + ", holder=" + this.holder + ", entityHelper=" + this.entityHelper + ", serializer=" + this.serializer + ")";
        }
    }

    private static final class ImmutableEntityBuilderImpl<T>
    extends ImmutableEntityBuilder<T, ImmutableEntity<T>, ImmutableEntityBuilderImpl<T>> {
        private ImmutableEntityBuilderImpl() {
        }

        @Override
        protected ImmutableEntityBuilderImpl<T> self() {
            return this;
        }

        @Override
        public ImmutableEntity<T> build() {
            return new ImmutableEntity(this);
        }
    }
}

