/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.eventsourcing.AppendEvents;
import io.fluxcapacitor.common.api.eventsourcing.DeleteEvents;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.common.api.eventsourcing.GetEvents;
import io.fluxcapacitor.common.api.eventsourcing.GetEventsResult;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetAggregateIdsResult;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebSocketEventStoreClient
extends AbstractWebsocketClient
implements EventStoreClient {
    private final int fetchBatchSize;

    public WebSocketEventStoreClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), 8192, clientConfig);
    }

    public WebSocketEventStoreClient(URI endPointUri, int fetchBatchSize, WebSocketClient.ClientConfig clientConfig) {
        this(endPointUri, fetchBatchSize, clientConfig, true);
    }

    public WebSocketEventStoreClient(URI endPointUri, int fetchBatchSize, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics) {
        super(endPointUri, clientConfig, sendMetrics, clientConfig.getEventSourcingSessions());
        this.fetchBatchSize = fetchBatchSize;
    }

    @Override
    public Awaitable storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly, Guarantee guarantee) {
        return this.sendCommand(new AppendEvents(List.of(new EventBatch(aggregateId, events, storeOnly)), guarantee));
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        AtomicReference highestSequenceNumber = new AtomicReference();
        GetEventsResult firstBatch = (GetEventsResult)this.sendAndWait(new GetEvents(aggregateId, lastSequenceNumber, this.fetchBatchSize));
        Stream eventStream = ObjectUtils.iterate(firstBatch, r -> (GetEventsResult)this.sendAndWait(new GetEvents(aggregateId, r.getLastSequenceNumber(), this.fetchBatchSize)), r -> r.getEventBatch().getEvents().size() < this.fetchBatchSize).flatMap(r -> {
            if (!r.getEventBatch().isEmpty()) {
                highestSequenceNumber.set(r.getLastSequenceNumber());
            }
            return r.getEventBatch().getEvents().stream();
        });
        return new AggregateEventStream<SerializedMessage>(eventStream, aggregateId, highestSequenceNumber::get);
    }

    @Override
    public Awaitable updateRelationships(UpdateRelationships request) {
        return this.sendCommand(request);
    }

    @Override
    public Map<String, String> getAggregateIds(GetAggregateIds request) {
        return ((GetAggregateIdsResult)this.sendAndWait(request)).getAggregateIds();
    }

    @Override
    public Awaitable deleteEvents(String aggregateId, Guarantee guarantee) {
        return Awaitable.fromFuture(this.send(new DeleteEvents(aggregateId, guarantee)));
    }
}

