/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.keyvalue.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.BooleanResult;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValueIfAbsent;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.common.api.keyvalue.StoreValuesAndWait;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebsocketKeyValueClient
extends AbstractWebsocketClient
implements KeyValueClient {
    public WebsocketKeyValueClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), clientConfig);
    }

    public WebsocketKeyValueClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig) {
        this(endpointUri, clientConfig, true);
    }

    public WebsocketKeyValueClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics) {
        super(endpointUri, clientConfig, sendMetrics, clientConfig.getKeyValueSessions());
    }

    @Override
    public Awaitable putValue(String key, Data<byte[]> value, Guarantee guarantee) {
        switch (guarantee) {
            case NONE: {
                this.sendAndForget(new StoreValues(List.of(new KeyValuePair(key, value)), guarantee));
                return Awaitable.ready();
            }
            case SENT: {
                return this.sendAndForget(new StoreValues(List.of(new KeyValuePair(key, value)), guarantee));
            }
        }
        return Awaitable.fromFuture(this.send(new StoreValuesAndWait(List.of(new KeyValuePair(key, value)))));
    }

    @Override
    public CompletableFuture<Boolean> putValueIfAbsent(String key, Data<byte[]> value) {
        return this.send(new StoreValueIfAbsent(new KeyValuePair(key, value))).thenApply(r -> ((BooleanResult)r).isSuccess());
    }

    @Override
    public Data<byte[]> getValue(String key) {
        GetValueResult result2 = (GetValueResult)this.sendAndWait(new GetValue(key));
        return result2.getValue();
    }

    @Override
    public Awaitable deleteValue(String key, Guarantee guarantee) {
        return this.sendCommand(new DeleteValue(key, guarantee));
    }
}

