/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.repository;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Aggregate;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.ImmutableAggregateRoot;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.modeling.ModifiableAggregateRoot;
import io.fluxcapacitor.javaclient.modeling.NoOpEntity;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.NoOpCache;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.NoOpSnapshotStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.NoSnapshotTrigger;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.PeriodicSnapshotTrigger;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotTrigger;
import io.fluxcapacitor.javaclient.persisting.repository.AggregateRepository;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAggregateRepository
implements AggregateRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultAggregateRepository.class);
    private final EventStore eventStore;
    private final SnapshotStore snapshotStore;
    private final Cache cache;
    private final Cache relationshipsCache;
    private final DocumentStore documentStore;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final EntityHelper entityHelper;
    private final Function<Class<?>, AnnotatedAggregateRepository<?>> delegates = ObjectUtils.memoize(type2 -> new AnnotatedAggregateRepository(type2, this.serializer(), this.cache(), this.relationshipsCache(), this.eventStore(), this.snapshotStore(), this.dispatchInterceptor(), this.entityHelper(), this.documentStore()));

    @Override
    public <T> Entity<T> load(String aggregateId, Class<T> type2) {
        if (Entity.isLoading()) {
            return new NoOpEntity(() -> this.delegates.apply(type2).load(aggregateId));
        }
        return this.delegates.apply(type2).load(aggregateId);
    }

    @Override
    public <T> Entity<T> loadFor(String entityId, Class<?> defaultType2) {
        Map<String, Class<?>> aggregates = this.getAggregatesFor(entityId);
        if (aggregates.isEmpty()) {
            return this.load(entityId, defaultType2);
        }
        if (aggregates.containsKey(entityId)) {
            return this.load(entityId, aggregates.get(entityId));
        }
        if (aggregates.size() > 1) {
            log.info("Found multiple aggregates containing entity {}. Loading the most recent one.", (Object)entityId);
        }
        return aggregates.entrySet().stream().filter(e -> !Void.class.equals(e.getValue())).reduce((a, b) -> b).map(e -> this.load((String)e.getKey(), (Class)e.getValue())).orElseGet(() -> this.load(entityId, defaultType2));
    }

    @Override
    public Map<String, Class<?>> getAggregatesFor(String entityId) {
        return this.relationshipsCache.computeIfAbsent(entityId, id -> this.eventStore.getAggregatesFor(entityId));
    }

    @Override
    public boolean cachingAllowed(Class<?> type2) {
        return this.delegates.apply(type2).isCached();
    }

    @ConstructorProperties(value={"eventStore", "snapshotStore", "cache", "relationshipsCache", "documentStore", "serializer", "dispatchInterceptor", "entityHelper"})
    public DefaultAggregateRepository(EventStore eventStore, SnapshotStore snapshotStore, Cache cache2, Cache relationshipsCache, DocumentStore documentStore, Serializer serializer, DispatchInterceptor dispatchInterceptor, EntityHelper entityHelper) {
        this.eventStore = eventStore;
        this.snapshotStore = snapshotStore;
        this.cache = cache2;
        this.relationshipsCache = relationshipsCache;
        this.documentStore = documentStore;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.entityHelper = entityHelper;
    }

    private EventStore eventStore() {
        return this.eventStore;
    }

    private SnapshotStore snapshotStore() {
        return this.snapshotStore;
    }

    private Cache cache() {
        return this.cache;
    }

    private Cache relationshipsCache() {
        return this.relationshipsCache;
    }

    private DocumentStore documentStore() {
        return this.documentStore;
    }

    private Serializer serializer() {
        return this.serializer;
    }

    private DispatchInterceptor dispatchInterceptor() {
        return this.dispatchInterceptor;
    }

    private EntityHelper entityHelper() {
        return this.entityHelper;
    }

    private Function<Class<?>, AnnotatedAggregateRepository<?>> delegates() {
        return this.delegates;
    }

    public static class AnnotatedAggregateRepository<T> {
        private final Class<T> type;
        private final Cache cache;
        private final Cache relationshipsCache;
        private final boolean eventSourced;
        private final boolean commitInBatch;
        private final SnapshotTrigger snapshotTrigger;
        private final SnapshotStore snapshotStore;
        private final boolean searchable;
        private final String collection;
        private final Function<Entity<?>, Instant> timestampFunction;
        private final Serializer serializer;
        private final EventStore eventStore;
        private final DispatchInterceptor dispatchInterceptor;
        private final EntityHelper entityHelper;
        private final DocumentStore documentStore;
        private final String idProperty;

        public AnnotatedAggregateRepository(Class<T> type2, Serializer serializer, Cache cache2, Cache relationshipsCache, EventStore eventStore, SnapshotStore snapshotStore, DispatchInterceptor dispatchInterceptor, EntityHelper entityHelper, DocumentStore documentStore) {
            this.serializer = serializer;
            this.relationshipsCache = relationshipsCache;
            this.eventStore = eventStore;
            this.dispatchInterceptor = dispatchInterceptor;
            this.entityHelper = entityHelper;
            this.documentStore = documentStore;
            Aggregate typeAnnotation = ReflectionUtils.getTypeAnnotation(type2, Aggregate.class);
            int snapshotPeriod = Optional.ofNullable(typeAnnotation).map(a -> a.eventSourced() || a.searchable() ? a.snapshotPeriod() : 1).orElseGet(ObjectUtils.safelySupply(() -> (int)((Integer)Aggregate.class.getMethod("snapshotPeriod", new Class[0]).getDefaultValue())));
            AtomicBoolean warnedAboutMissingTimePath = new AtomicBoolean();
            this.type = type2;
            this.cache = Optional.ofNullable(typeAnnotation).map(Aggregate::cached).orElseGet(ObjectUtils.safelySupply(() -> (boolean)((Boolean)Aggregate.class.getMethod("cached", new Class[0]).getDefaultValue()))) != false ? cache2 : NoOpCache.INSTANCE;
            this.eventSourced = Optional.ofNullable(typeAnnotation).map(Aggregate::eventSourced).orElseGet(ObjectUtils.safelySupply(() -> (boolean)((Boolean)Aggregate.class.getMethod("eventSourced", new Class[0]).getDefaultValue())));
            this.commitInBatch = Optional.ofNullable(typeAnnotation).map(Aggregate::commitInBatch).orElseGet(ObjectUtils.safelySupply(() -> (boolean)((Boolean)Aggregate.class.getMethod("commitInBatch", new Class[0]).getDefaultValue())));
            this.snapshotTrigger = snapshotPeriod > 0 ? new PeriodicSnapshotTrigger(snapshotPeriod) : NoSnapshotTrigger.INSTANCE;
            this.snapshotStore = snapshotPeriod > 0 ? snapshotStore : NoOpSnapshotStore.INSTANCE;
            this.searchable = Optional.ofNullable(typeAnnotation).map(Aggregate::searchable).orElseGet(ObjectUtils.safelySupply(() -> (boolean)((Boolean)Aggregate.class.getMethod("searchable", new Class[0]).getDefaultValue())));
            this.collection = Optional.ofNullable(typeAnnotation).map(Aggregate::collection).filter(s -> !s.isEmpty()).orElse(type2.getSimpleName());
            this.timestampFunction = Optional.ofNullable(typeAnnotation).map(Aggregate::timestampPath).filter(s -> !s.isBlank()).map(s -> aggregateRoot -> ReflectionUtils.readProperty(s, aggregateRoot.get()).map(t -> Instant.from((TemporalAccessor)t)).orElseGet(() -> {
                if (warnedAboutMissingTimePath.compareAndSet(false, true)) {
                    log.warn("Aggregate type {} does not declare a timestamp property at '{}'", (Object)aggregateRoot.get().getClass().getSimpleName(), s);
                }
                return aggregateRoot.timestamp();
            })).orElse(Entity::timestamp);
            this.idProperty = ReflectionUtils.getAnnotatedProperty(type2, EntityId.class).map(ReflectionUtils::getName).orElse(null);
        }

        protected ModifiableAggregateRoot<T> load(String id) {
            return ModifiableAggregateRoot.load(id, () -> {
                ImmutableAggregateRoot delegate = Optional.ofNullable((ImmutableAggregateRoot)this.cache.getIfPresent(id)).filter(a -> a.get() == null || this.type.isAssignableFrom(a.get().getClass())).orElseGet(() -> {
                    ImmutableAggregateRoot.ImmutableAggregateRootBuilder builder = (ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)ImmutableAggregateRoot.builder().id(id)).type(this.type)).idProperty(this.idProperty)).entityHelper(this.entityHelper)).serializer(this.serializer);
                    ImmutableEntity model = (this.searchable && !this.eventSourced ? this.documentStore.fetchDocument(id, this.collection).map(d -> ((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)builder.value(d)).build()) : this.snapshotStore.getSnapshot(id).map(a -> ImmutableAggregateRoot.from(a, this.entityHelper, this.serializer))).filter(a -> {
                        boolean assignable;
                        boolean bl = assignable = a.get() == null || this.type.isAssignableFrom(a.get().getClass());
                        if (!assignable) {
                            log.warn("Could not load aggregate {} because the requested type {} is not assignable to the stored type {}", id, this.type, a.get().getClass());
                        }
                        return assignable;
                    }).map(a -> a).orElseGet(builder::build);
                    if (!this.eventSourced) {
                        return model;
                    }
                    AggregateEventStream<DeserializingMessage> eventStream = this.eventStore.getEvents(id, ((ImmutableAggregateRoot)model).sequenceNumber());
                    Iterator<DeserializingMessage> iterator2 = eventStream.iterator();
                    boolean wasLoading = Entity.isLoading();
                    try {
                        Entity.loading.set(true);
                        while (iterator2.hasNext()) {
                            model = ((ImmutableAggregateRoot)model).apply(iterator2.next());
                        }
                    }
                    finally {
                        Entity.loading.set(wasLoading);
                    }
                    return ((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot.ImmutableAggregateRootBuilder)((ImmutableAggregateRoot)model).toBuilder()).sequenceNumber(eventStream.getLastSequenceNumber().orElse(((ImmutableAggregateRoot)model).sequenceNumber()))).build();
                });
                if (delegate.get() != null && !Entity.isLoading()) {
                    this.cache.putIfAbsent(id, delegate);
                }
                return delegate;
            }, this.commitInBatch, this.serializer, this.dispatchInterceptor, this::commit);
        }

        protected void commit(Entity<?> after, List<DeserializingMessage> unpublishedEvents, Entity<?> before) {
            try {
                this.cache.compute(after.id(), (id, current) -> current == null || Objects.equals(before.lastEventId(), current.lastEventId()) || unpublishedEvents.isEmpty() ? after : current.apply(unpublishedEvents));
                Set<Relationship> associations = after.associations(before);
                Set<Relationship> dissociations = after.dissociations(before);
                dissociations.forEach(r -> this.relationshipsCache.computeIfPresent(r.getEntityId(), (id, map) -> {
                    map.remove(r.getAggregateId());
                    return map;
                }));
                associations.forEach(r -> this.relationshipsCache.computeIfPresent(r.getEntityId(), (id, map) -> {
                    map.put(r.getAggregateId(), after.type());
                    return map;
                }));
                this.eventStore.updateRelationships(associations, dissociations).awaitSilently();
                if (!unpublishedEvents.isEmpty()) {
                    FluxCapacitor.getOptionally().ifPresent(fc -> unpublishedEvents.forEach(e -> e.getSerializedObject().setSource(fc.client().id())));
                    this.eventStore.storeEvents(after.id().toString(), new ArrayList<DeserializingMessage>(unpublishedEvents)).awaitSilently();
                    if (this.snapshotTrigger.shouldCreateSnapshot(after, unpublishedEvents)) {
                        this.snapshotStore.storeSnapshot(after);
                    }
                }
                if (this.searchable) {
                    Object value = after.get();
                    if (value == null) {
                        this.documentStore.deleteDocument(after.id().toString(), this.collection);
                    } else {
                        this.documentStore.index(value, after.id().toString(), this.collection, this.timestampFunction.apply(after));
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to commit aggregate {}", after.id(), (Object)e);
                this.cache.invalidate(after.id());
            }
        }

        protected boolean isCached() {
            return !(this.cache instanceof NoOpCache);
        }
    }
}

