/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.persisting.search.Search;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface DocumentStore {
    default public void index(Object object, String collection) {
        this.index(object instanceof Collection ? (List<Object>)object : Collections.singletonList(object), collection);
    }

    default public void index(Object object, String id, String collection) {
        this.index(object, id, collection, null);
    }

    default public void index(Object object, String id, String collection, Instant timestamp) {
        this.index(object, id, collection, timestamp, timestamp, Guarantee.STORED, false).get();
    }

    default public void index(Object object, String id, String collection, Instant begin, Instant end) {
        this.index(object, id, collection, begin, end, Guarantee.STORED, false).get();
    }

    public CompletableFuture<Void> index(Object var1, String var2, String var3, Instant var4, Instant var5, Guarantee var6, boolean var7);

    default public void index(Collection<?> objects, String collection) {
        this.index(objects, collection, (? super T v) -> ReflectionUtils.getAnnotatedPropertyValue(v, EntityId.class).map(Object::toString).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId()));
    }

    default public <T> void index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction) {
        this.index(objects, collection, idFunction, (? super T v) -> null);
    }

    default public void index(Collection<?> objects, String collection, String idPath, String timestampPath) {
        this.index(objects, collection, idPath, timestampPath, timestampPath, Guarantee.STORED, false).get();
    }

    default public void index(Collection<?> objects, String collection, String idPath, String beginPath, String endPath) {
        this.index(objects, collection, idPath, beginPath, endPath, Guarantee.STORED, false).get();
    }

    public CompletableFuture<Void> index(Collection<?> var1, String var2, String var3, String var4, String var5, Guarantee var6, boolean var7);

    default public <T> void index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> timestampFunction) {
        this.index(objects, collection, idFunction, timestampFunction, timestampFunction, Guarantee.STORED, false).get();
    }

    default public <T> void index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> beginFunction, Function<? super T, Instant> endFunction) {
        this.index(objects, collection, idFunction, beginFunction, endFunction, Guarantee.STORED, false).get();
    }

    public <T> CompletableFuture<Void> index(Collection<? extends T> var1, String var2, Function<? super T, String> var3, Function<? super T, Instant> var4, Function<? super T, Instant> var5, Guarantee var6, boolean var7);

    default public void indexIfNotExists(Object object, String collection) {
        this.indexIfNotExists(object instanceof Collection ? (List<Object>)object : Collections.singletonList(object), collection);
    }

    default public void indexIfNotExists(Object object, String id, String collection) {
        this.indexIfNotExists(object, id, collection, null);
    }

    default public void indexIfNotExists(Object object, String id, String collection, Instant timestamp) {
        this.index(object, id, collection, timestamp, timestamp, Guarantee.STORED, true).get();
    }

    default public void indexIfNotExists(Object object, String id, String collection, Instant begin, Instant end) {
        this.index(object, id, collection, begin, end, Guarantee.STORED, true).get();
    }

    default public <T> void indexIfNotExists(Collection<? extends T> objects, String collection) {
        this.indexIfNotExists(objects, collection, (? super T v) -> ReflectionUtils.getAnnotatedPropertyValue(v, EntityId.class).map(Object::toString).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId()));
    }

    default public <T> void indexIfNotExists(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction) {
        this.indexIfNotExists(objects, collection, idFunction, (? super T v) -> null);
    }

    default public <T> void indexIfNotExists(Collection<? extends T> objects, String collection, String idPath, String timestampPath) {
        this.index(objects, collection, idPath, timestampPath, timestampPath, Guarantee.STORED, true).get();
    }

    default public <T> void indexIfNotExists(Collection<? extends T> objects, String collection, String idPath, String beginPath, String endPath) {
        this.index(objects, collection, idPath, beginPath, endPath, Guarantee.STORED, true).get();
    }

    default public <T> void indexIfNotExists(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> timestampFunction) {
        this.index(objects, collection, idFunction, timestampFunction, timestampFunction, Guarantee.STORED, true).get();
    }

    default public <T> void indexIfNotExists(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> beginFunction, Function<? super T, Instant> endFunction) {
        this.index(objects, collection, idFunction, beginFunction, endFunction, Guarantee.STORED, true).get();
    }

    public CompletableFuture<Void> bulkUpdate(Collection<BulkUpdate> var1, Guarantee var2);

    default public void bulkUpdate(Collection<BulkUpdate> updates) {
        this.bulkUpdate(updates, Guarantee.STORED).get();
    }

    default public Search search(String ... collections) {
        return this.search(SearchQuery.builder().collections(Arrays.asList(collections)));
    }

    public Search search(SearchQuery.Builder var1);

    public <T> Optional<T> fetchDocument(String var1, String var2);

    public <T> Optional<T> fetchDocument(String var1, String var2, Class<T> var3);

    public CompletableFuture<Void> deleteDocument(String var1, String var2);

    public CompletableFuture<Void> deleteCollection(String var1);

    public CompletableFuture<Void> createAuditTrail(String var1, Duration var2);

    public DocumentSerializer getSerializer();
}

