/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SearchHit<T> {
    private final String id;
    private final String collection;
    private final Instant timestamp;
    private final Instant end;
    private final Supplier<T> valueSupplier;

    public T getValue() {
        return this.valueSupplier.get();
    }

    public <V> SearchHit<V> map(Function<T, V> mapper) {
        return new SearchHit<Object>(this.id, this.collection, this.timestamp, this.end, () -> mapper.apply(this.getValue()));
    }

    @ConstructorProperties(value={"id", "collection", "timestamp", "end", "valueSupplier"})
    public SearchHit(String id, String collection, Instant timestamp, Instant end, Supplier<T> valueSupplier) {
        this.id = id;
        this.collection = collection;
        this.timestamp = timestamp;
        this.end = end;
        this.valueSupplier = valueSupplier;
    }

    public String getId() {
        return this.id;
    }

    public String getCollection() {
        return this.collection;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Instant getEnd() {
        return this.end;
    }

    public Supplier<T> getValueSupplier() {
        return this.valueSupplier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchHit)) {
            return false;
        }
        SearchHit other = (SearchHit)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Instant this$end = this.getEnd();
        Instant other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Supplier<T> this$valueSupplier = this.getValueSupplier();
        Supplier<T> other$valueSupplier = other.getValueSupplier();
        return !(this$valueSupplier == null ? other$valueSupplier != null : !this$valueSupplier.equals(other$valueSupplier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        String $collection = this.getCollection();
        result2 = result2 * 59 + ($collection == null ? 43 : $collection.hashCode());
        Instant $timestamp = this.getTimestamp();
        result2 = result2 * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Instant $end = this.getEnd();
        result2 = result2 * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Supplier<T> $valueSupplier = this.getValueSupplier();
        result2 = result2 * 59 + ($valueSupplier == null ? 43 : $valueSupplier.hashCode());
        return result2;
    }

    public String toString() {
        return "SearchHit(id=" + this.getId() + ", collection=" + this.getCollection() + ", timestamp=" + this.getTimestamp() + ", end=" + this.getEnd() + ", valueSupplier=" + this.getValueSupplier() + ")";
    }
}

