/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocumentUpdate;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InMemorySearchClient
implements SearchClient {
    private final List<Document> documents = new CopyOnWriteArrayList<Document>();

    @Override
    public synchronized Awaitable index(List<Document> documents, Guarantee guarantee, boolean ifNotExists) {
        Function<Document, String> identify = d -> d.getCollection() + "/" + d.getId();
        Map existing = this.documents.stream().collect(Collectors.toMap(identify, Function.identity()));
        Map updates = documents.stream().collect(Collectors.toMap(identify, Function.identity(), (a, b) -> b, LinkedHashMap::new));
        if (ifNotExists) {
            updates.entrySet().stream().filter(e -> !existing.containsKey(e.getKey())).forEach(e -> this.documents.add((Document)e.getValue()));
        } else {
            updates.forEach((key, value) -> {
                Optional.ofNullable((Document)existing.get(key)).ifPresent(this.documents::remove);
                this.documents.add((Document)value);
            });
        }
        return Awaitable.ready();
    }

    @Override
    public Stream<SearchHit<Document>> search(SearchDocuments searchDocuments) {
        SearchQuery query = searchDocuments.getQuery();
        Stream<Document> documentStream = this.documents.stream().filter(query::matches);
        documentStream = documentStream.sorted(Document.createComparator(searchDocuments));
        if (!searchDocuments.getPathFilters().isEmpty()) {
            Predicate<Document.Path> pathFilter = searchDocuments.computePathFilter();
            documentStream = documentStream.map(d -> d.filterPaths(pathFilter));
        }
        if (searchDocuments.getSkip() > 0) {
            documentStream = documentStream.skip(searchDocuments.getSkip());
        }
        if (searchDocuments.getLastHit() != null) {
            documentStream = documentStream.dropWhile(d -> !d.getId().equals(searchDocuments.getLastHit().getId())).skip(1L);
        }
        if (searchDocuments.getMaxSize() != null) {
            documentStream = documentStream.limit(searchDocuments.getMaxSize().intValue());
        }
        return documentStream.map(d -> new SearchHit<Document>(d.getId(), d.getCollection(), d.getTimestamp(), d.getEnd(), () -> d));
    }

    @Override
    public Optional<Document> fetch(GetDocument r) {
        return this.documents.stream().filter(d -> Objects.equals(r.getId(), d.getId()) && Objects.equals(r.getCollection(), d.getCollection())).findFirst();
    }

    @Override
    public Awaitable delete(SearchQuery query, Guarantee guarantee) {
        this.documents.removeAll(this.documents.stream().filter(query::matches).collect(Collectors.toList()));
        return Awaitable.ready();
    }

    @Override
    public Awaitable delete(String documentId, String collection, Guarantee guarantee) {
        this.documents.removeIf(d -> Objects.equals(documentId, d.getId()) && Objects.equals(collection, d.getCollection()));
        return Awaitable.ready();
    }

    @Override
    public Awaitable createAuditTrail(CreateAuditTrail request) {
        return Awaitable.ready();
    }

    @Override
    public Awaitable deleteCollection(String collection, Guarantee guarantee) {
        this.documents.removeIf(d -> Objects.equals(collection, d.getCollection()));
        return Awaitable.ready();
    }

    @Override
    public List<DocumentStats> fetchStatistics(SearchQuery query, List<String> fields2, List<String> groupBy) {
        Map<List, List<Document>> groups2 = this.documents.stream().filter(query::matches).collect(Collectors.groupingBy(d -> groupBy.stream().map(g -> d.getEntryAtPath((String)g).map(Document.Entry::getValue).orElse(null)).collect(Collectors.toList())));
        Stream<DocumentStats> statsStream = groups2.entrySet().stream().map(e -> new DocumentStats(fields2.stream().collect(Collectors.toMap(Function.identity(), f -> this.getFieldStats((String)f, (List)e.getValue()), (a, b) -> b)), this.asMap(groupBy, (List)e.getKey())));
        return statsStream.sorted(DocumentStats.getComparator(groupBy)).collect(Collectors.toList());
    }

    @Override
    public SearchHistogram fetchHistogram(GetSearchHistogram request) {
        SearchQuery query = request.getQuery();
        List<Long> results = IntStream.range(0, request.getResolution()).mapToLong(i -> 0L).boxed().collect(Collectors.toList());
        if (query.getSince() == null) {
            return new SearchHistogram(query.getSince(), query.getBefore(), results);
        }
        if (query.getBefore() == null) {
            query = query.toBuilder().before(Instant.now()).build();
        }
        long min = query.getSince().toEpochMilli();
        long delta = query.getBefore().toEpochMilli() - min;
        long step = Math.min(1L, delta / (long)request.getResolution());
        this.search(SearchDocuments.builder().query(query).build()).collect(Collectors.groupingBy(d -> (d.getTimestamp().toEpochMilli() - min) / step)).forEach((bucket, hits) -> results.set(bucket.intValue(), Long.valueOf(hits.size())));
        return new SearchHistogram(query.getSince(), query.getBefore(), results);
    }

    @Override
    public Awaitable bulkUpdate(Collection<SerializedDocumentUpdate> updates, Guarantee guarantee) {
        updates.forEach(action -> {
            switch (action.getType()) {
                case delete: {
                    this.delete(action.getId(), action.getCollection(), guarantee);
                    break;
                }
                case index: 
                case indexIfNotExists: {
                    this.index(Collections.singletonList(action.getObject().deserializeDocument()), guarantee, action.getType().equals((Object)BulkUpdate.Type.indexIfNotExists));
                }
            }
        });
        return Awaitable.ready();
    }

    private DocumentStats.FieldStats getFieldStats(String path, List<Document> documents) {
        DocumentStats.FieldStats.FieldStatsBuilder builder = DocumentStats.FieldStats.builder().count(documents.size());
        if (path.isBlank()) {
            return builder.build();
        }
        List<BigDecimal> values2 = documents.stream().flatMap(d -> d.getEntryAtPath(path).stream()).filter(e -> e.getType() == Document.EntryType.NUMERIC).map(e -> new BigDecimal(e.getValue())).sorted().collect(Collectors.toList());
        if (!values2.isEmpty()) {
            builder.min((BigDecimal)values2.get(0));
            builder.max((BigDecimal)values2.get(values2.size() - 1));
            builder.average(DocumentStats.FieldStats.getAverage(values2));
        }
        return builder.build();
    }

    private Map<String, String> asMap(List<String> groupBy, List<String> values2) {
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        for (int i = 0; i < groupBy.size(); ++i) {
            result2.put(groupBy.get(i), values2.get(i));
        }
        return result2;
    }

    @Override
    public void close() {
    }
}

