/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;

public class DefaultResultGateway
implements ResultGateway {
    private final GatewayClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;

    @Override
    public CompletableFuture<Void> respond(Object payload, Metadata metadata2, String target, int requestId, Guarantee guarantee) {
        try {
            Message message = this.dispatchInterceptor.interceptDispatch(new Message(payload, metadata2), MessageType.RESULT);
            SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.RESULT);
            serializedMessage.setTarget(target);
            serializedMessage.setRequestId(requestId);
            return this.client.send(guarantee, serializedMessage).asCompletableFuture();
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send response %s", payload), e);
        }
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor"})
    public DefaultResultGateway(GatewayClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
    }
}

