/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.dataprotection;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.dataprotection.DropProtectedData;
import io.fluxcapacitor.javaclient.publishing.dataprotection.ProtectData;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProtectionInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataProtectionInterceptor.class);
    public static String METADATA_KEY = "$protectedData";
    private final KeyValueStore keyValueStore;
    private final Serializer serializer;

    @Override
    public Message interceptDispatch(Message m, MessageType messageType) {
        HashMap<String, String> protectedFields = new HashMap<String, String>();
        if (m.getMetadata().containsKey(METADATA_KEY)) {
            protectedFields.putAll(m.getMetadata().get(METADATA_KEY, Map.class));
        } else {
            Object payload = m.getPayload();
            ReflectionUtils.getAnnotatedFields(m.getPayload(), ProtectData.class).forEach(field -> ReflectionUtils.readProperty(field.getName(), payload).ifPresent(value -> {
                String key = FluxCapacitor.currentIdentityProvider().nextTechnicalId();
                this.keyValueStore.store(key, value, Guarantee.STORED);
                protectedFields.put(field.getName(), key);
            }));
            if (!protectedFields.isEmpty()) {
                m = m.withMetadata(m.getMetadata().with((Object)METADATA_KEY, (Object)protectedFields));
            }
        }
        if (!protectedFields.isEmpty()) {
            Object payloadCopy = this.serializer.deserialize(this.serializer.serialize(m.getPayload()));
            protectedFields.forEach((name, key) -> ReflectionUtils.writeProperty(name, payloadCopy, null));
            m = m.withPayload(payloadCopy);
        }
        return m;
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker, String consumer) {
        return m -> {
            if (m.getMetadata().containsKey(METADATA_KEY)) {
                Object payload = m.getPayload();
                Map protectedFields = m.getMetadata().get(METADATA_KEY, Map.class);
                boolean dropProtectedData = invoker.getMethod().isAnnotationPresent(DropProtectedData.class);
                protectedFields.forEach((fieldName, key) -> {
                    try {
                        ReflectionUtils.writeProperty(fieldName, payload, this.keyValueStore.get((String)key));
                    }
                    catch (Exception e) {
                        log.warn("Failed to set field {}", fieldName, (Object)e);
                    }
                    if (dropProtectedData) {
                        this.keyValueStore.delete((String)key);
                    }
                });
            }
            return function.apply((DeserializingMessage)m);
        };
    }

    @ConstructorProperties(value={"keyValueStore", "serializer"})
    public DataProtectionInterceptor(KeyValueStore keyValueStore, Serializer serializer) {
        this.keyValueStore = keyValueStore;
        this.serializer = serializer;
    }
}

