/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.ScheduledCommand;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulerException;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;

public class DefaultScheduler
implements Scheduler {
    private final SchedulingClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public void schedule(Schedule message, boolean ifAbsent) {
        try {
            if (Entity.isLoading()) {
                return;
            }
            message = (Schedule)this.dispatchInterceptor.interceptDispatch(message, MessageType.SCHEDULE);
            SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.SCHEDULE);
            this.client.schedule(new SerializedSchedule(message.getScheduleId(), message.getDeadline().toEpochMilli(), serializedMessage, ifAbsent)).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to schedule message %s for %s", message.getPayload(), message.getDeadline()), e);
        }
    }

    @Override
    public void scheduleCommand(Schedule command, boolean ifAbsent) {
        this.schedule(command.withPayload(new ScheduledCommand(command.serialize(this.serializer))).addMetadata("$commandType", (Object)command.getPayloadClass().getName()), ifAbsent);
    }

    @Override
    public void cancelSchedule(String scheduleId) {
        try {
            if (Entity.isLoading()) {
                return;
            }
            this.client.cancelSchedule(scheduleId).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to cancel schedule with id %s", scheduleId), e);
        }
    }

    @Override
    public Optional<Schedule> getSchedule(String scheduleId) {
        return Optional.ofNullable(this.client.getSchedule(scheduleId)).flatMap(s -> this.serializer.deserializeMessages(Stream.of(s.getMessage()), MessageType.SCHEDULE).findFirst().map(DeserializingMessage::toMessage).map(m -> new Schedule(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp(), s.getScheduleId(), Instant.ofEpochMilli(s.getTimestamp()))));
    }

    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        return this.localHandlerRegistry.registerHandler(target, handlerFilter);
    }

    public void handleLocally(Schedule schedule) {
        SerializedMessage serializedMessage = schedule.serialize(this.serializer);
        serializedMessage.setIndex(IndexUtils.indexFromTimestamp(schedule.getDeadline()));
        this.localHandlerRegistry.handle(new DeserializingMessage(serializedMessage, type2 -> this.serializer.convert(schedule.getPayload(), type2), MessageType.SCHEDULE));
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "localHandlerRegistry"})
    public DefaultScheduler(SchedulingClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.localHandlerRegistry = localHandlerRegistry;
    }
}

