/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.scheduling.Periodic;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import java.lang.reflect.Method;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SchedulingInterceptor.class);

    @Override
    public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler, String consumer) {
        Object target = handler.getTarget();
        List<Method> methods2 = ReflectionUtils.getAnnotatedMethods(target, HandleSchedule.class);
        for (Method method : methods2) {
            Periodic periodic = method.getAnnotation(Periodic.class);
            if (method.getParameterCount() <= 0) continue;
            Class<?> type2 = method.getParameters()[0].getType();
            if (periodic == null) {
                periodic = ReflectionUtils.getTypeAnnotation(type2, Periodic.class);
            }
            if (periodic == null) continue;
            try {
                this.initializePeriodicSchedule(type2, periodic);
            }
            catch (Exception e) {
                log.error("Failed to initialize periodic schedule on method {}. Continuing...", (Object)method, (Object)e);
            }
        }
        return HandlerInterceptor.super.wrap(handler, consumer);
    }

    protected void initializePeriodicSchedule(Class<?> payloadType, Periodic periodic) {
        if (periodic.value() <= 0L) {
            throw new IllegalStateException(String.format("Periodic annotation on type %s is invalid. Period should be a positive number of  milliseconds.", payloadType));
        }
        if (periodic.autoStart()) {
            Object payload;
            String scheduleId = periodic.scheduleId().isEmpty() ? payloadType.getName() : periodic.scheduleId();
            FluxCapacitor fluxCapacitor = FluxCapacitor.get();
            try {
                payload = ReflectionUtils.ensureAccessible(payloadType.getConstructor(new Class[0])).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error("No default constructor found on @Periodic type: {}. Add a public default constructor or initialize this periodic schedule by hand", (Object)payloadType, (Object)e);
                return;
            }
            Clock clock = fluxCapacitor.clock();
            Metadata metadata2 = Optional.ofNullable(fluxCapacitor.userProvider()).flatMap(p -> Optional.ofNullable(p.getSystemUser()).map(u -> p.addToMetadata(Metadata.empty(), (User)u))).orElse(Metadata.empty());
            fluxCapacitor.scheduler().schedule(new Schedule(payload, metadata2, scheduleId, clock.instant().plusMillis(periodic.initialDelay())), true);
        }
    }

    @Override
    public Message interceptDispatch(Message message, MessageType messageType) {
        if (messageType == MessageType.SCHEDULE) {
            message = message.withMetadata(message.getMetadata().with((Object)Schedule.scheduleIdMetadataKey, (Object)((Schedule)message).getScheduleId()));
        }
        return message;
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker, String consumer) {
        return m -> {
            if (m.getMessageType() == MessageType.SCHEDULE) {
                Object result2;
                long deadline = IndexUtils.millisFromIndex(m.getIndex());
                Periodic periodic = Optional.ofNullable(invoker.getMethod()).map(method -> method.getAnnotation(Periodic.class)).orElse(ReflectionUtils.getTypeAnnotation(m.getPayloadClass(), Periodic.class));
                Instant now = Instant.ofEpochMilli(deadline);
                try {
                    result2 = function.apply((DeserializingMessage)m);
                }
                catch (Exception e) {
                    if (periodic != null && periodic.continueOnError()) {
                        this.schedule((DeserializingMessage)m, now.plusMillis(periodic.value()));
                    }
                    throw e;
                }
                if (result2 instanceof TemporalAmount) {
                    this.schedule((DeserializingMessage)m, now.plus((TemporalAmount)result2));
                } else if (result2 instanceof TemporalAccessor) {
                    this.schedule((DeserializingMessage)m, Instant.from((TemporalAccessor)result2));
                } else if (result2 instanceof Schedule) {
                    this.schedule((Schedule)result2);
                } else if (result2 != null) {
                    Metadata metadata2 = m.getMetadata();
                    Object nextPayload = result2;
                    if (result2 instanceof Message) {
                        metadata2 = ((Message)result2).getMetadata();
                        nextPayload = ((Message)result2).getPayload();
                    }
                    if (nextPayload != null && m.getPayloadClass().isAssignableFrom(nextPayload.getClass())) {
                        if (periodic == null) {
                            Instant dispatched = m.getTimestamp();
                            Duration previousDelay = Duration.between(dispatched, now);
                            if (previousDelay.compareTo(Duration.ZERO) > 0) {
                                this.schedule(nextPayload, metadata2, now.plus(previousDelay));
                            } else {
                                log.info("Delay between the time this schedule was created and scheduled is <= 0, rescheduling with delay of 1 minute");
                                this.schedule(nextPayload, metadata2, now.plus(Duration.of(1L, ChronoUnit.MINUTES)));
                            }
                        } else {
                            this.schedule(nextPayload, metadata2, now.plusMillis(periodic.value()));
                        }
                    } else if (periodic != null) {
                        this.schedule((DeserializingMessage)m, now.plusMillis(periodic.value()));
                    }
                } else if (periodic != null) {
                    this.schedule((DeserializingMessage)m, now.plusMillis(periodic.value()));
                }
                return result2;
            }
            return function.apply((DeserializingMessage)m);
        };
    }

    private void schedule(DeserializingMessage message, Instant instant) {
        this.schedule(message.getPayload(), message.getMetadata(), instant);
    }

    private void schedule(Object payload, Metadata metadata2, Instant instant) {
        this.schedule(new Schedule(payload, metadata2, metadata2.getOrDefault(Schedule.scheduleIdMetadataKey, FluxCapacitor.currentIdentityProvider().nextTechnicalId()), instant));
    }

    private void schedule(Schedule schedule) {
        try {
            FluxCapacitor.get().scheduler().schedule(schedule);
        }
        catch (Exception e) {
            log.error("Failed to reschedule a {}", (Object)schedule.getPayloadClass(), (Object)e);
        }
    }
}

