/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.scheduling.CancelSchedule;
import io.fluxcapacitor.common.api.scheduling.GetSchedule;
import io.fluxcapacitor.common.api.scheduling.GetScheduleResult;
import io.fluxcapacitor.common.api.scheduling.Schedule;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import java.net.URI;
import java.util.Arrays;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebsocketSchedulingClient
extends AbstractWebsocketClient
implements SchedulingClient {
    public WebsocketSchedulingClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), clientConfig);
    }

    public WebsocketSchedulingClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig) {
        this(endpointUri, clientConfig, true);
    }

    public WebsocketSchedulingClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics) {
        super(endpointUri, clientConfig, sendMetrics, clientConfig.getGatewaySessions().get((Object)MessageType.SCHEDULE));
    }

    @Override
    public Awaitable schedule(Guarantee guarantee, SerializedSchedule ... schedules) {
        return this.sendCommand(new Schedule(Arrays.asList(schedules), guarantee));
    }

    @Override
    public Awaitable cancelSchedule(String scheduleId, Guarantee guarantee) {
        return this.sendCommand(new CancelSchedule(scheduleId, guarantee));
    }

    @Override
    public SerializedSchedule getSchedule(String scheduleId) {
        return ((GetScheduleResult)this.sendAndWait(new GetSchedule(scheduleId))).getSchedule();
    }
}

