/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.BatchProcessingException;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracking
implements Tracking {
    private static final Logger log = LoggerFactory.getLogger(DefaultTracking.class);
    private final Object $lock = new Object[0];
    private final HandlerFilter handlerFilter = ClientUtils::isTrackingHandler;
    private final MessageType messageType;
    private final ResultGateway resultGateway;
    private final List<ConsumerConfiguration> configurations;
    private final List<? extends BatchInterceptor> generalBatchInterceptors;
    private final Serializer serializer;
    private final HandlerFactory handlerFactory;
    private final Set<ConsumerConfiguration> startedConfigurations = new HashSet<ConsumerConfiguration>();
    private final Collection<CompletableFuture<?>> outstandingRequests = new CopyOnWriteArrayList();
    private final AtomicReference<Registration> shutdownFunction = new AtomicReference<Registration>(Registration.noOp());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration start(FluxCapacitor fluxCapacitor, List<?> handlers) {
        Object object = this.$lock;
        synchronized (object) {
            return fluxCapacitor.apply(fc -> {
                Map<ConsumerConfiguration, List> consumers = this.assignHandlersToConsumers(handlers).entrySet().stream().flatMap(e -> {
                    List converted = ((List)e.getValue()).stream().flatMap(target -> {
                        if (target instanceof Handler) {
                            return Stream.of((Handler)target);
                        }
                        return this.handlerFactory.createHandler(ReflectionUtils.asInstance(target), ((ConsumerConfiguration)e.getKey()).getName(), this.handlerFilter).stream();
                    }).collect(Collectors.toList());
                    return converted.isEmpty() ? Stream.empty() : Stream.of(new AbstractMap.SimpleEntry((ConsumerConfiguration)e.getKey(), converted));
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!Collections.disjoint(consumers.keySet(), this.startedConfigurations)) {
                    throw new TrackingException("Failed to start tracking. Consumers for some handlers have already started tracking.");
                }
                this.startedConfigurations.addAll(consumers.keySet());
                Registration registration = consumers.entrySet().stream().map(e -> this.startTracking((ConsumerConfiguration)e.getKey(), (List)e.getValue(), (FluxCapacitor)fc)).reduce(Registration::merge).orElse(Registration.noOp());
                this.shutdownFunction.updateAndGet(r -> r.merge(registration));
                return registration;
            });
        }
    }

    private Map<ConsumerConfiguration, List<Object>> assignHandlersToConsumers(List<?> handlers) {
        ArrayList unassignedHandlers = new ArrayList(handlers);
        LinkedHashMap configurations = Stream.concat(ConsumerConfiguration.configurations(handlers.stream().map(Object::getClass).collect(Collectors.toList())).filter(c -> c.getMessageType() == this.messageType), this.configurations.stream()).map(config -> config.toBuilder().batchInterceptors(this.generalBatchInterceptors).build()).collect(Collectors.toMap(ConsumerConfiguration::getName, Function.identity(), (a, b) -> {
            if (a.equals(b)) {
                return a.toBuilder().handlerFilter(a.getHandlerFilter().or(b.getHandlerFilter())).build();
            }
            throw new IllegalStateException(String.format("Consumer name %s is already in use", a.getName()));
        }, LinkedHashMap::new));
        Map<ConsumerConfiguration, List<Object>> result2 = configurations.values().stream().map(config -> {
            List matches = unassignedHandlers.stream().filter(h -> config.getHandlerFilter().test(h)).collect(Collectors.toList());
            if (config.exclusive()) {
                unassignedHandlers.removeAll(matches);
            }
            return Map.entry(config, matches);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        unassignedHandlers.removeAll(result2.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        unassignedHandlers.forEach(h -> {
            throw new TrackingException(String.format("Failed to find consumer for %s", h));
        });
        return result2;
    }

    protected Registration startTracking(ConsumerConfiguration configuration, List<Handler<DeserializingMessage>> handlers, FluxCapacitor fluxCapacitor) {
        return DefaultTracker.start(this.createConsumer(configuration, handlers), configuration, fluxCapacitor);
    }

    protected Consumer<List<SerializedMessage>> createConsumer(ConsumerConfiguration configuration, List<Handler<DeserializingMessage>> handlers) {
        return serializedMessages -> DeserializingMessage.handleBatch(this.serializer.deserializeMessages(serializedMessages.stream(), this.messageType)).forEach(m -> handlers.forEach(h -> this.tryHandle((DeserializingMessage)m, (Handler<DeserializingMessage>)h, configuration)));
    }

    protected void tryHandle(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        handler.findInvoker(message).ifPresent(h -> {
            try {
                this.reportResult(this.handle(message, (HandlerInvoker)h, handler, config), (HandlerInvoker)h, message, config);
            }
            catch (Throwable e) {
                this.reportResult(e, (HandlerInvoker)h, message, config);
                throw e instanceof BatchProcessingException ? new BatchProcessingException(String.format("Handler %s failed to handle a %s", handler, message), e.getCause(), ((BatchProcessingException)e).getMessageIndex()) : new BatchProcessingException(message.getIndex());
            }
        });
    }

    protected Object handle(DeserializingMessage message, HandlerInvoker h, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        try {
            Object result2 = Invocation.performInvocation(h::invoke);
            return result2 instanceof CompletableFuture ? ((CompletableFuture)result2).exceptionally(e -> message.apply(m -> this.processError((Throwable)e, message, h, handler, config))) : result2;
        }
        catch (Throwable e2) {
            return this.processError(e2, message, h, handler, config);
        }
    }

    protected Object processError(Throwable e, DeserializingMessage message, HandlerInvoker h, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        return config.getErrorHandler().handleError(e, String.format("Handler %s failed to handle a %s", handler, message), () -> Invocation.performInvocation(h::invoke));
    }

    protected void reportResult(Object result2, HandlerInvoker h, DeserializingMessage message, ConsumerConfiguration config) {
        if (result2 instanceof CompletableFuture) {
            ((CompletableFuture)result2).whenComplete((r, e) -> {
                try {
                    message.run(m -> this.reportResult(Optional.ofNullable(e).orElse((Throwable)r), h, message, config));
                }
                finally {
                    if (e != null) {
                        this.close();
                    }
                }
            });
        } else if (this.shouldSendResponse(h, message, config)) {
            if (result2 instanceof Throwable && !((result2 = ObjectUtils.unwrapException((Throwable)result2)) instanceof FunctionalException)) {
                result2 = new TechnicalException(String.format("Handler %s failed to handle a %s", h.getMethod(), message), (Throwable)result2);
            }
            SerializedMessage serializedMessage = message.getSerializedObject();
            this.resultGateway.respond(result2, serializedMessage.getSource(), serializedMessage.getRequestId());
        }
    }

    protected boolean shouldSendResponse(HandlerInvoker invoker, DeserializingMessage message, ConsumerConfiguration config) {
        return message.getSerializedObject().getRequestId() != null && !config.passive() && !invoker.isPassive() && message.getMessageType() != MessageType.RESULT && message.getMessageType() != MessageType.WEBRESPONSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            this.shutdownFunction.get().merge(() -> ClientUtils.waitForResults(Duration.ofSeconds(2L), this.outstandingRequests)).cancel();
        }
    }

    @ConstructorProperties(value={"messageType", "resultGateway", "configurations", "generalBatchInterceptors", "serializer", "handlerFactory"})
    public DefaultTracking(MessageType messageType, ResultGateway resultGateway, List<ConsumerConfiguration> configurations, List<? extends BatchInterceptor> generalBatchInterceptors, Serializer serializer, HandlerFactory handlerFactory) {
        this.messageType = messageType;
        this.resultGateway = resultGateway;
        this.configurations = configurations;
        this.generalBatchInterceptors = generalBatchInterceptors;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }
}

