/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.ClaimSegment;
import io.fluxcapacitor.common.api.tracking.ClaimSegmentResult;
import io.fluxcapacitor.common.api.tracking.DisconnectTracker;
import io.fluxcapacitor.common.api.tracking.GetPosition;
import io.fluxcapacitor.common.api.tracking.GetPositionResult;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Position;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.common.api.tracking.ReadFromIndex;
import io.fluxcapacitor.common.api.tracking.ReadFromIndexResult;
import io.fluxcapacitor.common.api.tracking.ReadResult;
import io.fluxcapacitor.common.api.tracking.ResetPosition;
import io.fluxcapacitor.common.api.tracking.StorePosition;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebsocketTrackingClient
extends AbstractWebsocketClient
implements TrackingClient {
    public WebsocketTrackingClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig, MessageType type2) {
        this(URI.create(endPointUrl), clientConfig, type2);
    }

    public WebsocketTrackingClient(URI endPointUri, WebSocketClient.ClientConfig clientConfig, MessageType type2) {
        this(endPointUri, clientConfig, type2, type2 != MessageType.METRICS);
    }

    public WebsocketTrackingClient(URI endPointUri, WebSocketClient.ClientConfig clientConfig, MessageType type2, boolean sendMetrics) {
        super(endPointUri, clientConfig, sendMetrics, clientConfig.getTrackingConfigs().get((Object)type2).getSessions());
    }

    @Override
    public CompletableFuture<MessageBatch> read(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration configuration) {
        return this.send(new Read(consumer, trackerId, configuration.getMaxFetchSize(), configuration.getMaxWaitDuration().toMillis(), configuration.getTypeFilter(), configuration.filterMessageTarget(), configuration.ignoreSegment(), configuration.singleTracker(), lastIndex, Optional.ofNullable(configuration.getPurgeDelay()).map(Duration::toMillis).orElse(null))).thenApply(ReadResult::getMessageBatch);
    }

    public CompletableFuture<ClaimSegmentResult> claimSegment(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration config) {
        return this.send(new ClaimSegment(consumer, trackerId, config.getMaxWaitDuration().toMillis(), config.getTypeFilter(), config.filterMessageTarget(), lastIndex, Optional.ofNullable(config.getPurgeDelay()).map(Duration::toMillis).orElse(null)));
    }

    @Override
    public List<SerializedMessage> readFromIndex(long minIndex, int maxSize) {
        ReadFromIndexResult result2 = (ReadFromIndexResult)this.sendAndWait(new ReadFromIndex(minIndex, maxSize));
        return result2.getMessages();
    }

    @Override
    public Awaitable storePosition(String consumer, int[] segment, long lastIndex, Guarantee guarantee) {
        return this.sendCommand(new StorePosition(consumer, segment, lastIndex, guarantee));
    }

    @Override
    public Awaitable resetPosition(String consumer, long lastIndex, Guarantee guarantee) {
        return this.sendCommand(new ResetPosition(consumer, lastIndex, guarantee));
    }

    @Override
    public Position getPosition(String consumer) {
        return ((GetPositionResult)this.sendAndWait(new GetPosition(consumer))).getPosition();
    }

    @Override
    public Awaitable disconnectTracker(String consumer, String trackerId, boolean sendFinalEmptyBatch, Guarantee guarantee) {
        return this.sendCommand(new DisconnectTracker(consumer, trackerId, sendFinalEmptyBatch, guarantee));
    }

    @Override
    public void close() {
        this.close(true);
    }
}

