/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface HandlerInterceptor {
    public static HandlerInterceptor noOp() {
        return (f, h, c) -> f;
    }

    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> var1, HandlerInvoker var2, String var3);

    default public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler, String consumer) {
        return new InterceptedHandler(handler, this, consumer);
    }

    default public HandlerInterceptor andThen(HandlerInterceptor nextInterceptor) {
        return new MergedInterceptor(this, nextInterceptor);
    }

    public static class InterceptedHandler
    implements Handler<DeserializingMessage> {
        private final Handler<DeserializingMessage> delegate;
        private final HandlerInterceptor interceptor;
        private final String consumer;

        @Override
        public Optional<HandlerInvoker> findInvoker(DeserializingMessage message) {
            Optional<HandlerInvoker> invoker = this.delegate.findInvoker(message);
            return invoker.map(s -> new HandlerInvoker.DelegatingHandlerInvoker((HandlerInvoker)s, (HandlerInvoker)s, message){
                final /* synthetic */ HandlerInvoker val$s;
                final /* synthetic */ DeserializingMessage val$message;
                {
                    this.val$s = handlerInvoker;
                    this.val$message = deserializingMessage;
                    super(delegate);
                }

                @Override
                public Object invoke(BiFunction<Object, Object, Object> combiner) {
                    return interceptor.interceptHandling(m -> this.val$s.invoke(), this.val$s, consumer).apply(this.val$message);
                }
            });
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate", "interceptor", "consumer"})
        public InterceptedHandler(Handler<DeserializingMessage> delegate, HandlerInterceptor interceptor, String consumer) {
            this.delegate = delegate;
            this.interceptor = interceptor;
            this.consumer = consumer;
        }

        @Override
        public Object getTarget() {
            return this.delegate.getTarget();
        }

        private static interface ExcludedMethods {
            public Optional<HandlerInvoker> findInvoker(DeserializingMessage var1);
        }
    }

    public static class MergedInterceptor
    implements HandlerInterceptor {
        private final HandlerInterceptor first;
        private final HandlerInterceptor second;

        @Override
        public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker, String consumer) {
            return this.first.interceptHandling(this.second.interceptHandling(function, invoker, consumer), invoker, consumer);
        }

        @Override
        public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler, String consumer) {
            return this.first.wrap(this.second.wrap(handler, consumer), consumer);
        }

        @ConstructorProperties(value={"first", "second"})
        public MergedInterceptor(HandlerInterceptor first, HandlerInterceptor second) {
            this.first = first;
            this.second = second;
        }
    }
}

