/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHandlerRegistry
implements HandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(LocalHandlerRegistry.class);
    private final MessageType messageType;
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        if (target instanceof Handler) {
            this.localHandlers.add((Handler)target);
            return () -> this.localHandlers.remove(target);
        }
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(ReflectionUtils.asInstance(target), "local-" + this.messageType, handlerFilter);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    @Override
    public Optional<CompletableFuture<Message>> handle(DeserializingMessage message) {
        if (!this.localHandlers.isEmpty()) {
            return message.apply(m -> {
                boolean handled = false;
                boolean logMessage = false;
                CompletionStage<Message> future = new CompletableFuture<Message>();
                for (Handler<DeserializingMessage> handler : this.localHandlers) {
                    Optional<HandlerInvoker> optionalInvoker = handler.findInvoker((DeserializingMessage)m);
                    if (!optionalInvoker.isPresent()) continue;
                    HandlerInvoker invoker = optionalInvoker.get();
                    boolean passive = invoker.isPassive();
                    try {
                        Object result2 = Invocation.performInvocation(invoker::invoke);
                        if (!passive && !future.isDone()) {
                            if (result2 instanceof CompletableFuture) {
                                future = ((CompletableFuture)result2).thenApply(Message::new);
                            } else {
                                future.complete(new Message(result2));
                            }
                        }
                        if (!passive) {
                            handled = true;
                        }
                        logMessage = logMessage || ClientUtils.getLocalHandlerAnnotation(handler.getTarget().getClass(), invoker.getMethod()).map(LocalHandler::logMessage).orElse(false) != false;
                    }
                    catch (Exception e) {
                        try {
                            if (passive) {
                                log.error("Passive local handler {} failed to handle a {}", handler, m.getPayloadClass(), e);
                            } else {
                                future.completeExceptionally(e);
                            }
                            if (!passive) {
                                handled = true;
                            }
                            logMessage = logMessage || ClientUtils.getLocalHandlerAnnotation(handler.getTarget().getClass(), invoker.getMethod()).map(LocalHandler::logMessage).orElse(false) != false;
                        }
                        catch (Throwable throwable) {
                            if (!passive) {
                                handled = true;
                            }
                            logMessage = logMessage || ClientUtils.getLocalHandlerAnnotation(handler.getTarget().getClass(), invoker.getMethod()).map(LocalHandler::logMessage).orElse(false) != false;
                            throw throwable;
                        }
                    }
                }
                try {
                    Optional optional = handled ? Optional.of(future) : Optional.empty();
                    return optional;
                }
                finally {
                    if (logMessage) {
                        FluxCapacitor.getOptionally().ifPresent(fc -> fc.client().getGatewayClient(m.getMessageType()).send(Guarantee.NONE, message.getSerializedObject()));
                    }
                }
            });
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"messageType", "handlerFactory"})
    public LocalHandlerRegistry(MessageType messageType, HandlerFactory handlerFactory) {
        this.messageType = messageType;
        this.handlerFactory = handlerFactory;
    }
}

