/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.validation;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.ForbidsRole;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.RequiresRole;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UnauthenticatedException;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UnauthorizedException;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Jsr380JakartaValidator;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Jsr380JavaxValidator;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidateWith;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationException;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);
    public static final Validator defaultValidator = Optional.of(ServiceLoader.load(Validator.class)).map(ServiceLoader::iterator).filter(Iterator::hasNext).map(Iterator::next).orElseGet(() -> {
        try {
            Jsr380JakartaValidator validator = Jsr380JakartaValidator.createDefault();
            log.info("Using {} for validation", (Object)Jsr380JakartaValidator.class.getSimpleName());
            return validator;
        }
        catch (Throwable ignored) {
            log.info("Using {} for validation", (Object)Jsr380JavaxValidator.class.getSimpleName());
            return Jsr380JavaxValidator.createDefault();
        }
    });
    private static final Function<Class<?>, Class<?>[]> validateWithGroups = ObjectUtils.memoize(type2 -> {
        ValidateWith annotation = type2.getAnnotation(ValidateWith.class);
        if (annotation == null) {
            return new Class[0];
        }
        return annotation.value();
    });
    private static final Function<Class<?>, String[]> requiredRolesCache = ObjectUtils.memoize(payloadClass -> ValidationUtils.getRequiredRoles(ReflectionUtils.getTypeAnnotations(payloadClass)));
    private static final BiFunction<Class<?>, Executable, String[]> requiredRolesForMethodCache = ObjectUtils.memoize((target, executable) -> Optional.ofNullable(ValidationUtils.getRequiredRoles(Arrays.asList(executable.getAnnotations()))).orElseGet(() -> ValidationUtils.getRequiredRoles(ReflectionUtils.getTypeAnnotations(target))));

    public static Optional<ValidationException> checkValidity(Object object, Class<?> ... groups2) {
        return ValidationUtils.checkValidity(object, defaultValidator, groups2);
    }

    public static boolean isValid(Object object, Class<?> ... groups2) {
        return ValidationUtils.isValid(object, defaultValidator, groups2);
    }

    public static void assertValid(Object object, Class<?> ... groups2) {
        ValidationUtils.assertValid(object, defaultValidator, groups2);
    }

    public static Optional<ValidationException> checkValidity(Object object, Validator validator, Class<?> ... groups2) {
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(o -> ValidationUtils.checkValidity(o, validator, groups2)).reduce((a, b) -> a.isEmpty() ? b : a).orElse(Optional.empty());
        }
        return validator.checkValidity(object, ValidationUtils.getValidationGroups(object, groups2));
    }

    public static boolean isValid(Object object, Validator validator, Class<?> ... groups2) {
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(o -> ValidationUtils.isValid(o, validator, groups2)).reduce((a, b) -> a != false && b != false).orElse(true);
        }
        return validator.isValid(object, ValidationUtils.getValidationGroups(object, groups2));
    }

    public static void assertValid(Object object, Validator validator, Class<?> ... groups2) {
        if (object instanceof Iterable) {
            ((Iterable)object).forEach(o -> ValidationUtils.assertValid(o, validator, groups2));
        } else {
            validator.assertValid(object, ValidationUtils.getValidationGroups(object, groups2));
        }
    }

    private static Class<?>[] getValidationGroups(Object object, Class<?>[] customGroups) {
        if (customGroups.length > 0 || object == null) {
            return customGroups;
        }
        return validateWithGroups.apply(object.getClass());
    }

    public static void assertAuthorized(Class<?> payloadType, User user) throws UnauthenticatedException, UnauthorizedException {
        String[] requiredRoles = requiredRolesCache.apply(payloadType);
        ValidationUtils.assertAuthorized(payloadType.getSimpleName(), user, requiredRoles);
    }

    public static Optional<Exception> checkAuthorization(Class<?> payloadType, User user) {
        try {
            ValidationUtils.assertAuthorized(payloadType, user);
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static boolean isAuthorized(Class<?> payloadType, User user) {
        return ValidationUtils.checkAuthorization(payloadType, user).isEmpty();
    }

    public static boolean isAuthorized(Class<?> target, Executable method, User user) {
        try {
            ValidationUtils.assertAuthorized(method.getName(), user, requiredRolesForMethodCache.apply(target, method));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static void assertAuthorized(String action, User user, String[] requiredRoles) {
        if (requiredRoles != null) {
            if (user == null) {
                throw new UnauthenticatedException(String.format("%s requires authentication", action));
            }
            ArrayList remainingRoles = new ArrayList();
            if (Arrays.stream(requiredRoles).filter(r -> {
                if (r.startsWith("!")) {
                    return true;
                }
                remainingRoles.add(r);
                return false;
            }).anyMatch(r -> user.hasRole(r.substring(1)))) {
                throw new UnauthorizedException(String.format("User %s is unauthorized to execute %s", user.getName(), action));
            }
            if (!remainingRoles.isEmpty()) {
                if (remainingRoles.stream().noneMatch(user::hasRole)) {
                    throw new UnauthorizedException(String.format("User %s is unauthorized to execute %s", user.getName(), action));
                }
            }
        }
    }

    protected static String[] getRequiredRoles(Iterable<? extends Annotation> annotations2) {
        for (Annotation annotation : annotations2) {
            if (annotation instanceof RequiresRole) {
                return ((RequiresRole)annotation).value();
            }
            if (annotation.annotationType().isAnnotationPresent(RequiresRole.class)) {
                for (Method method : ReflectionUtils.getAllMethods(annotation.annotationType())) {
                    if (!method.getName().equalsIgnoreCase("value")) continue;
                    Object[] result2 = (Object[])method.invoke((Object)annotation, new Object[0]);
                    return (String[])Arrays.stream(result2).map(Object::toString).toArray(String[]::new);
                }
            }
            if (annotation instanceof ForbidsRole) {
                return (String[])Arrays.stream(((ForbidsRole)annotation).value()).map(s -> "!" + s).toArray(String[]::new);
            }
            if (!annotation.annotationType().isAnnotationPresent(ForbidsRole.class)) continue;
            for (Method method : ReflectionUtils.getAllMethods(annotation.annotationType())) {
                if (!method.getName().equalsIgnoreCase("value")) continue;
                Object[] result3 = (Object[])method.invoke((Object)annotation, new Object[0]);
                return (String[])Arrays.stream(result3).map(Object::toString).map(s -> "!" + s).toArray(String[]::new);
            }
        }
        return null;
    }
}

