/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.metrics;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import io.fluxcapacitor.javaclient.tracking.metrics.CompleteMessageEvent;
import io.fluxcapacitor.javaclient.tracking.metrics.HandleMessageEvent;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerMonitor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HandlerMonitor.class);

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker, String consumer) {
        return message -> {
            Instant start = Instant.now();
            try {
                Object result2 = function.apply((DeserializingMessage)message);
                this.publishMetrics(invoker, consumer, (DeserializingMessage)message, false, start, result2);
                return result2;
            }
            catch (Throwable e) {
                this.publishMetrics(invoker, consumer, (DeserializingMessage)message, true, start, e);
                throw e;
            }
        };
    }

    protected void publishMetrics(HandlerInvoker invoker, String consumer, DeserializingMessage message, boolean exceptionalResult, Instant start, Object result2) {
        try {
            boolean logMetrics = ClientUtils.getLocalHandlerAnnotation(invoker.getTarget().getClass(), invoker.getMethod()).map(LocalHandler::logMetrics).orElse(true);
            if (logMetrics) {
                boolean completed = !(result2 instanceof CompletableFuture) || ((CompletableFuture)result2).isDone();
                FluxCapacitor.getOptionally().ifPresent(fc -> fc.metricsGateway().publish(new HandleMessageEvent(consumer, invoker.getTarget().getClass().getSimpleName(), message.getIndex(), message.getType(), exceptionalResult, start.until(Instant.now(), ChronoUnit.NANOS), completed)));
                if (!completed) {
                    Map<String, String> correlationData = FluxCapacitor.currentCorrelationData();
                    ((CompletionStage)result2).whenComplete((r, e) -> message.run(m -> FluxCapacitor.getOptionally().ifPresent(fc -> fc.metricsGateway().publish(new CompleteMessageEvent(consumer, invoker.getTarget().getClass().getSimpleName(), m.getIndex(), m.getType(), e != null, start.until(Instant.now(), ChronoUnit.NANOS)), Metadata.of(correlationData)))));
                }
            }
        }
        catch (Exception e2) {
            log.error("Failed to publish handler metrics", e2);
        }
    }
}

