/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.net.HttpCookie;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class WebRequest
extends Message {
    private static final Map<Executable, Predicate<HasMessage>> filterCache = new ConcurrentHashMap<Executable, Predicate<HasMessage>>();
    @NonNull
    private final String path;
    @NonNull
    private final HttpRequestMethod method;
    @NonNull
    private final Map<String, List<String>> headers;
    @JsonIgnore
    private final AtomicReference<Object> cookies = new AtomicReference();

    public static Builder builder() {
        return new Builder();
    }

    public static MessageFilter<HasMessage> getWebRequestFilter() {
        return (message, executable) -> filterCache.computeIfAbsent(executable, e -> {
            HandleWebParams handleWeb = ReflectionUtils.getAnnotationAs(e, HandleWeb.class, HandleWebParams.class).orElseThrow();
            Predicate<String> pathTest = Optional.of(handleWeb.getValue()).map(url -> url.startsWith("/") ? url : "/" + url).map(SearchUtils::convertGlobToRegex).map(Pattern::asMatchPredicate).map(p -> s -> p.test(s.startsWith("/") ? s : "/" + s)).orElse(p -> true);
            Predicate<String> methodTest = Optional.of(handleWeb.getMethod()).map(r -> r == HttpRequestMethod.ANY ? p -> true : p -> r.name().equals(p)).orElse(p -> true);
            return msg -> {
                String path = Objects.requireNonNull(msg.getMetadata().get("url"), "Web request url is missing in the metadata of a WebRequest message");
                String method = Objects.requireNonNull(msg.getMetadata().get("method"), "Web request method is missing in the metadata of a WebRequest message");
                return pathTest.test(path) && methodTest.test(method);
            };
        }).test(message);
    }

    private WebRequest(Builder builder) {
        super(builder.payload(), Metadata.of("url", builder.url(), "method", builder.method().name(), "headers", builder.headers()));
        this.path = builder.url();
        this.method = builder.method();
        this.headers = builder.headers();
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    WebRequest(Object payload, Metadata metadata2, String messageId, Instant timestamp) {
        super(payload, metadata2, messageId, timestamp);
        this.path = WebRequest.getUrl(metadata2);
        this.method = WebRequest.getMethod(metadata2);
        this.headers = WebRequest.getHeaders(metadata2);
    }

    public WebRequest(Message m) {
        this(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp());
    }

    @Override
    public SerializedMessage serialize(Serializer serializer) {
        return this.headers.getOrDefault("Content-Type", List.of()).stream().findFirst().map(format -> new SerializedMessage(serializer.serialize(this.getPayload(), (String)format), this.getMetadata(), this.getMessageId(), this.getTimestamp().toEpochMilli())).orElseGet(() -> super.serialize(serializer));
    }

    @Override
    public WebRequest withMetadata(Metadata metadata2) {
        return new WebRequest(super.withMetadata(metadata2));
    }

    @Override
    public WebRequest addMetadata(Metadata metadata2) {
        return (WebRequest)super.addMetadata(metadata2);
    }

    @Override
    public WebRequest addMetadata(String key, Object value) {
        return (WebRequest)super.addMetadata(key, value);
    }

    @Override
    public WebRequest addMetadata(Object ... keyValues) {
        return (WebRequest)super.addMetadata(keyValues);
    }

    @Override
    public WebRequest addMetadata(Map<String, ?> values2) {
        return (WebRequest)super.addMetadata(values2);
    }

    @Override
    public WebRequest withPayload(Object payload) {
        return new WebRequest(super.withPayload(payload));
    }

    public String getHeader(String name) {
        return this.getHeaders(name).stream().findFirst().orElse(null);
    }

    public List<String> getHeaders(String name) {
        return this.headers.getOrDefault(name, Collections.emptyList());
    }

    public Optional<HttpCookie> getCookie(String name) {
        return this.getCookies().stream().filter(c -> Objects.equals(name, c.getName())).findFirst();
    }

    public static String getUrl(Metadata metadata2) {
        return Optional.ofNullable(metadata2.get("url")).map(u -> u.startsWith("/") ? u : "/" + u).orElseThrow(() -> new IllegalStateException("WebRequest is malformed: url is missing"));
    }

    public static HttpRequestMethod getMethod(Metadata metadata2) {
        return Optional.ofNullable(metadata2.get("method")).map(m -> {
            try {
                return HttpRequestMethod.valueOf(m);
            }
            catch (Exception e) {
                throw new IllegalStateException("WebRequest is malformed: unrecognized http method");
            }
        }).orElseThrow(() -> new IllegalStateException("WebRequest is malformed: http method is missing"));
    }

    public static Map<String, List<String>> getHeaders(Metadata metadata2) {
        return Optional.ofNullable(metadata2.get("headers", Map.class)).orElse(Collections.emptyMap());
    }

    public static Optional<HttpCookie> getCookie(Metadata metadata2, String name) {
        return WebRequest.getHeaders(metadata2).getOrDefault("Cookie", Collections.emptyList()).stream().findFirst().flatMap(h -> HttpCookie.parse(h).stream().filter(c -> Objects.equals(name, c.getName())).findFirst());
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public HttpRequestMethod getMethod() {
        return this.method;
    }

    @NonNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebRequest)) {
            return false;
        }
        WebRequest other = (WebRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        HttpRequestMethod this$method = this.getMethod();
        HttpRequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<HttpCookie> this$cookies = this.getCookies();
        List<HttpCookie> other$cookies = other.getCookies();
        return !(this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        String $path = this.getPath();
        result2 = result2 * 59 + ($path == null ? 43 : $path.hashCode());
        HttpRequestMethod $method = this.getMethod();
        result2 = result2 * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result2 = result2 * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<HttpCookie> $cookies = this.getCookies();
        result2 = result2 * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        return result2;
    }

    @Override
    public String toString() {
        return "WebRequest(super=" + super.toString() + ", path=" + this.getPath() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ", cookies=" + this.getCookies() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpCookie> getCookies() {
        Object value = this.cookies.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.cookies;
            synchronized (atomicReference) {
                value = this.cookies.get();
                if (value == null) {
                    List actualValue = Optional.ofNullable(this.getHeader("Cookie")).map(HttpCookie::parse).orElse(Collections.emptyList());
                    value = actualValue == null ? this.cookies : actualValue;
                    this.cookies.set(value);
                }
            }
        }
        return (List)(value == this.cookies ? null : value);
    }

    public static class Builder {
        private String url;
        private HttpRequestMethod method;
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>();
        private Object payload;

        public Builder header(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder cookie(HttpCookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Builder payload(Object payload) {
            this.payload = payload;
            if (!this.headers().containsKey("Content-Type")) {
                if (payload instanceof String) {
                    return this.contentType("text/plain");
                }
                if (payload instanceof byte[]) {
                    return this.contentType("application/octet-stream");
                }
            }
            return this;
        }

        public Map<String, List<String>> headers() {
            Map<String, List<String>> result2 = this.headers;
            if (!this.cookies.isEmpty()) {
                result2 = new HashMap<String, List<String>>(this.headers);
                result2.put("Cookie", List.of(this.cookies.stream().map(HttpCookie::toString).collect(Collectors.joining("; "))));
            }
            return result2;
        }

        public WebRequest build() {
            return new WebRequest(this);
        }

        public String url() {
            return this.url;
        }

        public HttpRequestMethod method() {
            return this.method;
        }

        public List<HttpCookie> cookies() {
            return this.cookies;
        }

        public Object payload() {
            return this.payload;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(HttpRequestMethod method) {
            this.method = method;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.url();
            String other$url = other.url();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            HttpRequestMethod this$method = this.method();
            HttpRequestMethod other$method = other.method();
            if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.headers();
            Map<String, List<String>> other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            List<HttpCookie> this$cookies = this.cookies();
            List<HttpCookie> other$cookies = other.cookies();
            if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
                return false;
            }
            Object this$payload = this.payload();
            Object other$payload = other.payload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $url = this.url();
            result2 = result2 * 59 + ($url == null ? 43 : $url.hashCode());
            HttpRequestMethod $method = this.method();
            result2 = result2 * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
            Map<String, List<String>> $headers = this.headers();
            result2 = result2 * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            List<HttpCookie> $cookies = this.cookies();
            result2 = result2 * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
            Object $payload = this.payload();
            result2 = result2 * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result2;
        }

        public String toString() {
            return "WebRequest.Builder(url=" + this.url() + ", method=" + this.method() + ", headers=" + this.headers() + ", cookies=" + this.cookies() + ", payload=" + this.payload() + ")";
        }
    }

    protected static final class HandleWebParams {
        private final String value;
        private final HttpRequestMethod method;

        @ConstructorProperties(value={"value", "method"})
        public HandleWebParams(String value, HttpRequestMethod method) {
            this.value = value;
            this.method = method;
        }

        public String getValue() {
            return this.value;
        }

        public HttpRequestMethod getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandleWebParams)) {
                return false;
            }
            HandleWebParams other = (HandleWebParams)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            HttpRequestMethod this$method = this.getMethod();
            HttpRequestMethod other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $value = this.getValue();
            result2 = result2 * 59 + ($value == null ? 43 : $value.hashCode());
            HttpRequestMethod $method = this.getMethod();
            result2 = result2 * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
            return result2;
        }

        public String toString() {
            return "WebRequest.HandleWebParams(value=" + this.getValue() + ", method=" + this.getMethod() + ")";
        }
    }
}

