/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.web.WebUtils;
import java.beans.ConstructorProperties;
import java.net.HttpCookie;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class WebResponse
extends Message {
    @NonNull
    private final Map<String, List<String>> headers;
    private final Integer status;

    public static Builder builder() {
        return new Builder();
    }

    private WebResponse(Builder builder) {
        super(builder.payload(), Metadata.of("status", builder.status(), "headers", builder.headers()));
        this.status = builder.status();
        this.headers = builder.headers();
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    WebResponse(Object payload, Metadata metadata2, String messageId, Instant timestamp) {
        super(payload, metadata2, messageId, timestamp);
        this.headers = Optional.ofNullable(metadata2.get("headers", Map.class)).orElse(Collections.emptyMap());
        this.status = Optional.ofNullable(metadata2.get("status")).map(Integer::valueOf).orElse(null);
    }

    public WebResponse(Message m) {
        this(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp());
    }

    @Override
    public SerializedMessage serialize(Serializer serializer) {
        return this.headers.getOrDefault("Content-Type", List.of()).stream().findFirst().map(format -> new SerializedMessage(serializer.serialize(this.getPayload(), (String)format), this.getMetadata(), this.getMessageId(), this.getTimestamp().toEpochMilli())).orElseGet(() -> super.serialize(serializer));
    }

    public static Metadata asMetadata(int statusCode, Map<String, List<String>> headers) {
        return Metadata.of("status", statusCode, "headers", headers);
    }

    @Override
    public WebResponse withMetadata(Metadata metadata2) {
        return new WebResponse(super.withMetadata(metadata2));
    }

    @Override
    public WebResponse addMetadata(Metadata metadata2) {
        return (WebResponse)super.addMetadata(metadata2);
    }

    @Override
    public WebResponse addMetadata(String key, Object value) {
        return (WebResponse)super.addMetadata(key, value);
    }

    @Override
    public WebResponse addMetadata(Object ... keyValues) {
        return (WebResponse)super.addMetadata(keyValues);
    }

    @Override
    public WebResponse addMetadata(Map<String, ?> values2) {
        return (WebResponse)super.addMetadata(values2);
    }

    @Override
    public WebResponse withPayload(Object payload) {
        return new WebResponse(super.withPayload(payload));
    }

    public static Map<String, List<String>> getHeaders(Metadata metadata2) {
        return Optional.ofNullable(metadata2.get("headers", Map.class)).orElse(Collections.emptyMap());
    }

    public static Integer getStatusCode(Metadata metadata2) {
        return Optional.ofNullable(metadata2.get("status")).map(Integer::valueOf).orElse(null);
    }

    @NonNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Integer getStatus() {
        return this.status;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResponse)) {
            return false;
        }
        WebResponse other = (WebResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        Integer $status = this.getStatus();
        result2 = result2 * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result2 = result2 * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result2;
    }

    @Override
    public String toString() {
        return "WebResponse(super=" + super.toString() + ", headers=" + this.getHeaders() + ", status=" + this.getStatus() + ")";
    }

    public static class Builder {
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>();
        private Object payload;
        private Integer status;

        public Builder payload(Object payload) {
            this.payload = payload;
            if (!this.headers().containsKey("Content-Type")) {
                if (payload instanceof String) {
                    return this.contentType("text/plain");
                }
                if (payload instanceof byte[]) {
                    return this.contentType("application/octet-stream");
                }
            }
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder cookie(HttpCookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Map<String, List<String>> headers() {
            Map<String, List<String>> result2 = this.headers;
            if (!this.cookies.isEmpty()) {
                result2 = new HashMap<String, List<String>>(this.headers);
                result2.put("Set-Cookie", this.cookies.stream().map(WebUtils::toString).collect(Collectors.toList()));
            }
            return result2;
        }

        public Integer status() {
            return this.status == null ? (this.payload == null ? 204 : 200) : this.status;
        }

        public WebResponse build() {
            return new WebResponse(this);
        }

        public List<HttpCookie> cookies() {
            return this.cookies;
        }

        public Object payload() {
            return this.payload;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.status();
            Integer other$status = other.status();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.headers();
            Map<String, List<String>> other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            List<HttpCookie> this$cookies = this.cookies();
            List<HttpCookie> other$cookies = other.cookies();
            if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
                return false;
            }
            Object this$payload = this.payload();
            Object other$payload = other.payload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            Integer $status = this.status();
            result2 = result2 * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            Map<String, List<String>> $headers = this.headers();
            result2 = result2 * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            List<HttpCookie> $cookies = this.cookies();
            result2 = result2 * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
            Object $payload = this.payload();
            result2 = result2 * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result2;
        }

        public String toString() {
            return "WebResponse.Builder(headers=" + this.headers() + ", cookies=" + this.cookies() + ", payload=" + this.payload() + ", status=" + this.status() + ")";
        }
    }
}

