/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver;

import io.fluxcapacitor.common.ObjectUtils;
import java.util.Optional;
import java.util.function.Function;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiClientEndpoint
extends Endpoint {
    private static final Logger log = LoggerFactory.getLogger(MultiClientEndpoint.class);
    private final ObjectUtils.MemoizingFunction<String, Endpoint> endpointSupplier;

    public MultiClientEndpoint(Function<String, Endpoint> endpointSupplier) {
        this.endpointSupplier = ObjectUtils.memoize(endpointSupplier);
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        this.endpointSupplier.apply(this.getProjectId(session)).onOpen(session, config);
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        this.endpointSupplier.apply(this.getProjectId(session)).onClose(session, closeReason);
    }

    @Override
    public void onError(Session session, Throwable thr) {
        this.endpointSupplier.apply(this.getProjectId(session)).onError(session, thr);
    }

    private String getProjectId(Session session) {
        return Optional.ofNullable(session.getRequestParameterMap().get("projectId")).map(list -> (String)list.get(0)).orElse("public");
    }
}

