/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.ServicePathBuilder;
import io.fluxcapacitor.javaclient.configuration.client.InMemoryClient;
import io.fluxcapacitor.javaclient.scheduling.client.InMemorySchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.InMemoryMessageStore;
import io.fluxcapacitor.testserver.WebsocketDeploymentUtils;
import io.fluxcapacitor.testserver.endpoints.ConsumerEndpoint;
import io.fluxcapacitor.testserver.endpoints.EventSourcingEndpoint;
import io.fluxcapacitor.testserver.endpoints.KeyValueEndPoint;
import io.fluxcapacitor.testserver.endpoints.ProducerEndpoint;
import io.fluxcapacitor.testserver.endpoints.SchedulingEndpoint;
import io.fluxcapacitor.testserver.endpoints.SearchEndpoint;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import java.util.Arrays;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer {
    private static final Logger log = LoggerFactory.getLogger(TestServer.class);
    private static final Function<String, InMemoryClient> clients = ObjectUtils.memoize(projectId -> InMemoryClient.newInstance());

    public static void main(String[] args2) {
        TestServer.start(Integer.getInteger("port", 8080));
    }

    public static void start(int port) {
        PathHandler pathHandler = Handlers.path();
        for (MessageType messageType : Arrays.asList(MessageType.METRICS, MessageType.EVENT, MessageType.COMMAND, MessageType.QUERY, MessageType.RESULT, MessageType.ERROR, MessageType.WEBREQUEST, MessageType.WEBRESPONSE)) {
            pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ProducerEndpoint(TestServer.getMessageStore(projectId, messageType)), String.format("/%s/", ServicePathBuilder.producerPath(messageType)), pathHandler);
            pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint(TestServer.getMessageStore(projectId, messageType), messageType), String.format("/%s/", ServicePathBuilder.consumerPath(messageType)), pathHandler);
        }
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint(TestServer.getMessageStore(projectId, MessageType.NOTIFICATION), MessageType.NOTIFICATION), String.format("/%s/", ServicePathBuilder.consumerPath(MessageType.NOTIFICATION)), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new EventSourcingEndpoint(clients.apply((String)projectId).getEventStoreClient()), String.format("/%s/", ServicePathBuilder.eventSourcingPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new KeyValueEndPoint(clients.apply((String)projectId).getKeyValueClient()), String.format("/%s/", ServicePathBuilder.keyValuePath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new SearchEndpoint(clients.apply((String)projectId).getSearchClient()), String.format("/%s/", ServicePathBuilder.searchPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new SchedulingEndpoint(clients.apply((String)projectId).getSchedulingClient()), String.format("/%s/", ServicePathBuilder.schedulingPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint((InMemorySchedulingClient)clients.apply((String)projectId).getSchedulingClient(), MessageType.SCHEDULE), String.format("/%s/", ServicePathBuilder.consumerPath(MessageType.SCHEDULE)), pathHandler);
        pathHandler = pathHandler.addPrefixPath("/health", exchange -> {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
            exchange.getResponseSender().send("Healthy");
        });
        GracefulShutdownHandler shutdownHandler = new GracefulShutdownHandler(pathHandler);
        Undertow server = Undertow.builder().addHttpListener(port, "0.0.0.0").setHandler(shutdownHandler).build();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Initiating controlled shutdown");
            shutdownHandler.shutdown();
            try {
                shutdownHandler.awaitShutdown(1000L);
            }
            catch (InterruptedException e) {
                log.warn("Thread to kill server was interrupted");
                Thread.currentThread().interrupt();
            }
        }));
        log.info("Flux Capacitor test server running on port {}", (Object)port);
    }

    private static InMemoryMessageStore getMessageStore(String projectId, MessageType messageType) {
        if (messageType == MessageType.NOTIFICATION) {
            messageType = MessageType.EVENT;
        }
        return (InMemoryMessageStore)clients.apply(projectId).getGatewayClient(messageType);
    }
}

