/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.RequestBatch;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.common.serialization.compression.CompressionUtils;
import io.fluxcapacitor.testserver.Handle;
import io.undertow.util.SameThreadExecutor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebsocketEndpoint
extends Endpoint {
    private static final Logger log = LoggerFactory.getLogger(WebsocketEndpoint.class);
    private static final ObjectMapper defaultObjectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).findAndAddModules()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).build();
    private final ObjectMapper objectMapper;
    private final Executor requestExecutor;
    private final Executor responseExecutor;
    private final Map<String, Session> openSessions = new ConcurrentHashMap<String, Session>();
    protected final AtomicBoolean shuttingDown = new AtomicBoolean();
    protected volatile boolean shutDown;
    private final Handler<Request> handler = HandlerInspector.createHandler((Object)this, Handle.class, Arrays.asList(new ParameterResolver<Request>(){

        @Override
        public boolean matches(Parameter parameter, Annotation methodAnnotation, Request value, Object target) {
            return parameter.getType().isAssignableFrom(value.getPayload().getClass());
        }

        @Override
        public Function<Request, Object> resolve(Parameter p, Annotation methodAnnotation) {
            return Request::getPayload;
        }

        @Override
        public boolean determinesSpecificity() {
            return true;
        }
    }, (p, methodAnnotation) -> {
        if (p.getType().equals(Session.class)) {
            return Request::getSession;
        }
        return null;
    }));

    protected WebsocketEndpoint() {
        this(Executors.newFixedThreadPool(32));
    }

    protected WebsocketEndpoint(Executor requestExecutor) {
        this(defaultObjectMapper, requestExecutor, requestExecutor);
    }

    protected WebsocketEndpoint(ObjectMapper objectMapper, Executor requestExecutor, Executor responseExecutor) {
        this.objectMapper = objectMapper;
        this.requestExecutor = Optional.ofNullable(requestExecutor).orElse(SameThreadExecutor.INSTANCE);
        this.responseExecutor = Optional.ofNullable(responseExecutor).orElse(SameThreadExecutor.INSTANCE);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutDown));
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        if (this.shuttingDown.get()) {
            throw new IllegalStateException("Cannot accept client. Endpoint is shutting down");
        }
        this.openSessions.put(session.getId(), session);
        session.addMessageHandler(byte[].class, bytes -> {
            Runnable task = () -> {
                try {
                    this.handleMessage(session, (byte[])bytes);
                }
                catch (Exception e) {
                    log.error("Failed to handle request", e);
                }
            };
            if (this.requestExecutor == null) {
                task.run();
            } else {
                CompletableFuture.runAsync(task, this.requestExecutor);
            }
        });
    }

    protected void handleMessage(Session session, byte[] bytes) {
        JsonType value;
        try {
            value = this.objectMapper.readValue(CompressionUtils.decompress(bytes, this.getCompressionAlgorithm(session)), this.getRequestType());
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Failed to parse incoming message as JsonType", e2);
        }
        if (this.shutDown) {
            throw new IllegalStateException(String.format("Rejecting request %s from client %s with id %s because the service is shutting down", value, this.getClientName(session), this.getClientId(session)));
        }
        if (this.shuttingDown.get()) {
            log.info("Silently ignoring request {} from client {} with id {} because the service is shutting down", value, this.getClientName(session), this.getClientId(session));
            return;
        }
        this.handleRequest(session, value);
    }

    private void handleRequest(Session session, JsonType value) {
        Object result2;
        if (value instanceof RequestBatch) {
            ((RequestBatch)value).getRequests().forEach(r -> this.handleRequest(session, (JsonType)r));
            return;
        }
        HandlerInvoker invoker = this.handler.findInvoker(new Request(value, session)).orElseThrow(() -> new IllegalArgumentException("Could not find find a handler for request " + value));
        try {
            result2 = invoker.invoke();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not handle request " + value, e);
        }
        if (result2 != null) {
            this.sendResult(session, result2);
        }
    }

    protected Class<? extends JsonType> getRequestType() {
        return JsonType.class;
    }

    protected void sendResult(Session session, Object result2) {
        this.responseExecutor.execute(() -> {
            if (session.isOpen()) {
                try (OutputStream outputStream = session.getBasicRemote().getSendStream();){
                    byte[] bytes = this.objectMapper.writeValueAsBytes(result2);
                    outputStream.write(CompressionUtils.compress(bytes, this.getCompressionAlgorithm(session)));
                }
                catch (Exception e) {
                    log.error("Failed to send websocket result to client {}, id {}", this.getClientName(session), this.getClientId(session), e);
                }
            }
        });
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        this.openSessions.remove(session.getId());
        if (closeReason.getCloseCode() != CloseReason.CloseCodes.UNEXPECTED_CONDITION && closeReason.getCloseCode().getCode() > CloseReason.CloseCodes.NO_STATUS_CODE.getCode()) {
            log.warn("Websocket session for client {} with id {} closed abnormally: {}", this.getClientName(session), this.getClientId(session), closeReason);
        }
    }

    @Override
    public void onError(Session session, Throwable e) {
        log.error("Error in session for client {} with id {}", this.getClientName(session), this.getClientId(session), e);
        try {
            session.close(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, "The websocket closed because of an error"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void shutDown() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.shutDown = true;
                this.openSessions.values().stream().filter(Session::isOpen).forEach(session -> {
                    try {
                        session.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
    }

    protected CompressionAlgorithm getCompressionAlgorithm(Session session) {
        List<String> compression = session.getRequestParameterMap().get("compression");
        if (compression == null) {
            return null;
        }
        return CompressionAlgorithm.valueOf(compression.get(0));
    }

    protected String getProjectId(Session session) {
        return Optional.ofNullable(session.getRequestParameterMap().get("projectId")).map(list -> (String)list.get(0)).orElse("public");
    }

    protected String getClientId(Session session) {
        return session.getRequestParameterMap().get("clientId").get(0);
    }

    protected String getClientName(Session session) {
        return session.getRequestParameterMap().get("clientName").get(0);
    }

    private static final class Request {
        private final JsonType payload;
        private final Session session;

        @ConstructorProperties(value={"payload", "session"})
        public Request(JsonType payload, Session session) {
            this.payload = payload;
            this.session = session;
        }

        public JsonType getPayload() {
            return this.payload;
        }

        public Session getSession() {
            return this.session;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            JsonType this$payload = this.getPayload();
            JsonType other$payload = other.getPayload();
            if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
                return false;
            }
            Session this$session = this.getSession();
            Session other$session = other.getSession();
            return !(this$session == null ? other$session != null : !this$session.equals(other$session));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            JsonType $payload = this.getPayload();
            result2 = result2 * 59 + ($payload == null ? 43 : $payload.hashCode());
            Session $session = this.getSession();
            result2 = result2 * 59 + ($session == null ? 43 : $session.hashCode());
            return result2;
        }

        public String toString() {
            return "WebsocketEndpoint.Request(payload=" + this.getPayload() + ", session=" + this.getSession() + ")";
        }
    }
}

