/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.endpoints;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.VoidResult;
import io.fluxcapacitor.common.api.eventsourcing.AppendEvents;
import io.fluxcapacitor.common.api.eventsourcing.DeleteEvents;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.common.api.eventsourcing.GetEvents;
import io.fluxcapacitor.common.api.eventsourcing.GetEventsResult;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetAggregateIdsResult;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.testserver.Handle;
import io.fluxcapacitor.testserver.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSourcingEndpoint
extends WebsocketEndpoint {
    private static final Logger log = LoggerFactory.getLogger(EventSourcingEndpoint.class);
    private final EventStoreClient eventStore;

    @Handle
    public VoidResult handle(AppendEvents appendEvents) throws Exception {
        List results = appendEvents.getEventBatches().stream().map(b -> this.eventStore.storeEvents(b.getAggregateId(), b.getEvents(), b.isStoreOnly())).collect(Collectors.toList());
        for (Awaitable awaitable : results) {
            awaitable.await();
        }
        return new VoidResult(appendEvents.getRequestId());
    }

    @Handle
    public VoidResult handle(DeleteEvents deleteEvents) throws Exception {
        this.eventStore.deleteEvents(deleteEvents.getAggregateId()).awaitSilently();
        return new VoidResult(deleteEvents.getRequestId());
    }

    @Handle
    public GetEventsResult handle(GetEvents getEvents) throws Exception {
        AggregateEventStream<SerializedMessage> stream = this.eventStore.getEvents(getEvents.getAggregateId(), getEvents.getLastSequenceNumber());
        long lastSequenceNumber = stream.getLastSequenceNumber().orElse(-1L);
        return new GetEventsResult(getEvents.getRequestId(), new EventBatch(getEvents.getAggregateId(), stream.collect(Collectors.toList()), false), lastSequenceNumber);
    }

    @Handle
    public VoidResult handle(UpdateRelationships request) {
        Awaitable awaitable = this.eventStore.updateRelationships(request);
        if (request.getGuarantee().compareTo(Guarantee.STORED) >= 0) {
            awaitable.awaitSilently();
            return new VoidResult(request.getRequestId());
        }
        return null;
    }

    @Handle
    public GetAggregateIdsResult handle(GetAggregateIds request) {
        return new GetAggregateIdsResult(request.getRequestId(), this.eventStore.getAggregateIds(request));
    }

    @ConstructorProperties(value={"eventStore"})
    public EventSourcingEndpoint(EventStoreClient eventStore) {
        this.eventStore = eventStore;
    }
}

