/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.endpoints;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.BooleanResult;
import io.fluxcapacitor.common.api.VoidResult;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValueIfAbsent;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.common.api.keyvalue.StoreValuesAndWait;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.testserver.Handle;
import io.fluxcapacitor.testserver.WebsocketEndpoint;
import java.beans.ConstructorProperties;

public class KeyValueEndPoint
extends WebsocketEndpoint {
    private final KeyValueClient keyValueStore;

    @Handle
    public void handle(StoreValues storeValues) {
        for (KeyValuePair value : storeValues.getValues()) {
            this.keyValueStore.putValue(value.getKey(), value.getValue(), Guarantee.NONE);
        }
    }

    @Handle
    public VoidResult handle(StoreValuesAndWait storeValues) throws Exception {
        for (KeyValuePair value : storeValues.getValues()) {
            this.keyValueStore.putValue(value.getKey(), value.getValue(), Guarantee.STORED).await();
        }
        return new VoidResult(storeValues.getRequestId());
    }

    @Handle
    public BooleanResult handle(StoreValueIfAbsent r) throws Exception {
        return new BooleanResult(r.getRequestId(), this.keyValueStore.putValueIfAbsent(r.getValue().getKey(), r.getValue().getValue()).get());
    }

    @Handle
    public GetValueResult handle(GetValue getValue) {
        return new GetValueResult(getValue.getRequestId(), this.keyValueStore.getValue(getValue.getKey()));
    }

    @Handle
    public void handle(DeleteValue deleteValue) {
        this.keyValueStore.deleteValue(deleteValue.getKey());
    }

    public String toString() {
        return "KeyValueEndpoint";
    }

    @ConstructorProperties(value={"keyValueStore"})
    public KeyValueEndPoint(KeyValueClient keyValueStore) {
        this.keyValueStore = keyValueStore;
    }
}

