/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.endpoints;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.publishing.Append;
import io.fluxcapacitor.javaclient.tracking.client.InMemoryMessageStore;
import io.fluxcapacitor.testserver.Handle;
import io.fluxcapacitor.testserver.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerEndpoint
extends WebsocketEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ProducerEndpoint.class);
    private final InMemoryMessageStore store;

    @Handle
    public Awaitable handle(Append request) {
        Awaitable awaitable = Awaitable.ready();
        try {
            awaitable = this.store.send(Guarantee.SENT, (SerializedMessage[])request.getMessages().toArray(SerializedMessage[]::new));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
        }
        return request.getGuarantee().compareTo(Guarantee.STORED) >= 0 ? awaitable : null;
    }

    @ConstructorProperties(value={"store"})
    public ProducerEndpoint(InMemoryMessageStore store) {
        this.store = store;
    }
}

