/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.endpoints;

import io.fluxcapacitor.common.api.scheduling.CancelSchedule;
import io.fluxcapacitor.common.api.scheduling.GetSchedule;
import io.fluxcapacitor.common.api.scheduling.GetScheduleResult;
import io.fluxcapacitor.common.api.scheduling.Schedule;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.testserver.Handle;
import io.fluxcapacitor.testserver.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingEndpoint
extends WebsocketEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SchedulingEndpoint.class);
    private final SchedulingClient store;

    @Handle
    public void handle(Schedule schedule) {
        this.store.schedule((SerializedSchedule[])schedule.getMessages().toArray(SerializedSchedule[]::new));
    }

    @Handle
    public void handle(CancelSchedule cancelSchedule) {
        this.store.cancelSchedule(cancelSchedule.getScheduleId());
    }

    @Handle
    public GetScheduleResult handle(GetSchedule request) {
        return new GetScheduleResult(request.getRequestId(), this.store.getSchedule(request.getScheduleId()));
    }

    @ConstructorProperties(value={"store"})
    public SchedulingEndpoint(SchedulingClient store) {
        this.store = store;
    }
}

