/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.endpoints;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.VoidResult;
import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.BulkUpdateDocuments;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DeleteCollection;
import io.fluxcapacitor.common.api.search.DeleteDocumentById;
import io.fluxcapacitor.common.api.search.DeleteDocuments;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetDocumentResult;
import io.fluxcapacitor.common.api.search.GetDocumentStats;
import io.fluxcapacitor.common.api.search.GetDocumentStatsResult;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.GetSearchHistogramResult;
import io.fluxcapacitor.common.api.search.IndexDocuments;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchDocumentsResult;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.api.search.SerializedDocumentUpdate;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.testserver.Handle;
import io.fluxcapacitor.testserver.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEndpoint
extends WebsocketEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SearchEndpoint.class);
    private final SearchClient store;

    @Handle
    public VoidResult handle(IndexDocuments request) throws Exception {
        try {
            List<Document> documents = request.getDocuments().stream().map(SerializedDocument::deserializeDocument).collect(Collectors.toList());
            Awaitable awaitable = this.store.index(documents, request.getGuarantee(), request.isIfNotExists());
            if (request.getGuarantee().compareTo(Guarantee.STORED) >= 0) {
                awaitable.await();
            }
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
        }
        return request.getGuarantee().compareTo(Guarantee.STORED) >= 0 ? new VoidResult(request.getRequestId()) : null;
    }

    @Handle
    public VoidResult handle(BulkUpdateDocuments request) throws Exception {
        Map<BulkUpdate.Type, List<SerializedDocumentUpdate>> updatesByType = request.getUpdates().stream().filter(Objects::nonNull).collect(Collectors.toMap(a -> String.format("%s_%s", a.getCollection(), a.getId()), UnaryOperator.identity(), (a, b) -> b)).values().stream().collect(Collectors.groupingBy(SerializedDocumentUpdate::getType));
        try {
            ArrayList results = new ArrayList();
            Optional.ofNullable(updatesByType.get((Object)BulkUpdate.Type.index)).ifPresent(updates -> {
                List<Document> documents = updates.stream().map(u -> u.getObject().deserializeDocument()).collect(Collectors.toList());
                results.add(this.store.index(documents, request.getGuarantee(), false));
            });
            Optional.ofNullable(updatesByType.get((Object)BulkUpdate.Type.indexIfNotExists)).ifPresent(updates -> {
                List<Document> documents = updates.stream().map(u -> u.getObject().deserializeDocument()).collect(Collectors.toList());
                results.add(this.store.index(documents, request.getGuarantee(), true));
            });
            updatesByType.getOrDefault((Object)BulkUpdate.Type.delete, Collections.emptyList()).forEach(delete -> this.store.delete(delete.getId(), delete.getCollection(), request.getGuarantee()));
            if (request.getGuarantee().compareTo(Guarantee.STORED) >= 0) {
                for (Awaitable result2 : results) {
                    result2.await();
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
        }
        return request.getGuarantee().compareTo(Guarantee.STORED) >= 0 ? new VoidResult(request.getRequestId()) : null;
    }

    @Handle
    public SearchDocumentsResult handle(SearchDocuments request) {
        try {
            Stream<SearchHit<Document>> result2 = this.store.search(request);
            return new SearchDocumentsResult(request.getRequestId(), result2.map(d -> new SerializedDocument((Document)d.getValue())).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new SearchDocumentsResult(request.getRequestId(), Collections.emptyList());
        }
    }

    @Handle
    public GetSearchHistogramResult handle(GetSearchHistogram request) {
        try {
            return new GetSearchHistogramResult(request.getRequestId(), this.store.fetchHistogram(request));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new GetSearchHistogramResult(request.getRequestId(), new SearchHistogram(request.getQuery().getSince(), request.getQuery().getBefore(), Collections.emptyList()));
        }
    }

    @Handle
    public GetDocumentStatsResult handle(GetDocumentStats request) {
        try {
            return new GetDocumentStatsResult(request.getRequestId(), this.store.fetchStatistics(request.getQuery(), request.getFields(), request.getGroupBy()));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new GetDocumentStatsResult(request.getRequestId(), Collections.emptyList());
        }
    }

    @Handle
    public GetDocumentResult handle(GetDocument request) {
        try {
            return new GetDocumentResult(request.getRequestId(), this.store.fetch(request).map(SerializedDocument::new).orElse(null));
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
            return new GetDocumentResult(request.getRequestId(), null);
        }
    }

    @Handle
    public VoidResult handle(DeleteDocuments request) throws Exception {
        try {
            Awaitable awaitable = this.store.delete(request.getQuery(), request.getGuarantee());
            if (request.getGuarantee().compareTo(Guarantee.STORED) >= 0) {
                awaitable.await();
            }
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
        }
        return request.getGuarantee().compareTo(Guarantee.STORED) >= 0 ? new VoidResult(request.getRequestId()) : null;
    }

    @Handle
    public VoidResult handle(DeleteDocumentById request) throws Exception {
        try {
            this.store.delete(request.getId(), request.getCollection(), request.getGuarantee());
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
        }
        return new VoidResult(request.getRequestId());
    }

    @Handle
    public VoidResult handle(DeleteCollection request) throws Exception {
        try {
            this.store.deleteCollection(request.getCollection());
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
        }
        return new VoidResult(request.getRequestId());
    }

    @Handle
    public VoidResult handle(CreateAuditTrail request) throws Exception {
        try {
            this.store.createAuditTrail(request);
        }
        catch (Exception e) {
            log.error("Failed to handle {}", (Object)request, (Object)e);
        }
        return new VoidResult(request.getRequestId());
    }

    public String toString() {
        return "SearchEndpoint";
    }

    @ConstructorProperties(value={"store"})
    public SearchEndpoint(SearchClient store) {
        this.store = store;
    }
}

