/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.endpoints;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.javaclient.tracking.client.TrackerRead;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class WebSocketTrackerRead
implements TrackerRead {
    private final Read read;
    private final String clientId;
    private final String sessionId;
    private final long deadline;
    private final Predicate<String> typeFilter;
    private final MessageType messageType;

    public WebSocketTrackerRead(Read read, String clientId, String sessionId, MessageType messageType) {
        this.read = read;
        this.typeFilter = WebSocketTrackerRead.toPredicate(read.getTypeFilter());
        this.deadline = System.currentTimeMillis() + read.getMaxTimeout();
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.messageType = messageType;
    }

    private static Predicate<String> toPredicate(String typeFilter) {
        if (typeFilter == null) {
            return s -> true;
        }
        return Pattern.compile(typeFilter).asMatchPredicate();
    }

    @Override
    public boolean canHandle(SerializedMessage message) {
        return !(this.isFilterMessageTarget() && message.getTarget() != null && !this.clientId.equals(message.getTarget()) || message.getData().getType() != null && !this.typeFilter.test(message.getData().getType()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketTrackerRead that = (WebSocketTrackerRead)o;
        return Objects.equals(this.getConsumer(), that.getConsumer()) && Objects.equals(this.getTrackerId(), that.getTrackerId());
    }

    public int hashCode() {
        return Objects.hash(this.getConsumer(), this.getTrackerId());
    }

    public String toString() {
        return "WebSocketTracker{consumerName='" + this.getConsumer() + "', clientId='" + this.clientId + "', trackerId='" + this.getTrackerId() + "'}";
    }

    public Read getRead() {
        return this.read;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    public Predicate<String> getTypeFilter() {
        return this.typeFilter;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean isIgnoreMessageTarget() {
        return this.getRead().isIgnoreMessageTarget();
    }

    @Override
    public String getConsumer() {
        return this.getRead().getConsumer();
    }

    @Override
    public String getTrackerId() {
        return this.getRead().getTrackerId();
    }

    @Override
    public int getMaxSize() {
        return this.getRead().getMaxSize();
    }

    public long getMaxTimeout() {
        return this.getRead().getMaxTimeout();
    }

    public boolean isFilterMessageTarget() {
        return this.getRead().isFilterMessageTarget();
    }

    public boolean isIgnoreSegment() {
        return this.getRead().isIgnoreSegment();
    }

    public boolean isSingleTracker() {
        return this.getRead().isSingleTracker();
    }

    @Override
    public Long getLastIndex() {
        return this.getRead().getLastIndex();
    }

    @Override
    public Long getPurgeTimeout() {
        return this.getRead().getPurgeTimeout();
    }

    public long getRequestId() {
        return this.getRead().getRequestId();
    }

    public Object toMetric() {
        return this.getRead().toMetric();
    }
}

