/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.UndertowClientMessages;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;

public class UndertowClientMessages_$bundle
implements UndertowClientMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final UndertowClientMessages_$bundle INSTANCE = new UndertowClientMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected UndertowClientMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String connectionClosed$str() {
        return "UT001000: Connection closed";
    }

    @Override
    public final String connectionClosed() {
        return String.format(this.getLoggingLocale(), this.connectionClosed$str(), new Object[0]);
    }

    protected String requestAlreadyWritten$str() {
        return "UT001001: Request already written";
    }

    @Override
    public final IllegalStateException requestAlreadyWritten() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.requestAlreadyWritten$str(), new Object[0]));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String failedToUpgradeChannel$str() {
        return "UT001020: Failed to upgrade channel due to response %s (%s)";
    }

    @Override
    public final String failedToUpgradeChannel(int responseCode, String reason) {
        return String.format(this.getLoggingLocale(), this.failedToUpgradeChannel$str(), responseCode, reason);
    }

    protected String illegalContentLength$str() {
        return "UT001030: invalid content length %d";
    }

    @Override
    public final IllegalArgumentException illegalContentLength(long length) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalContentLength$str(), length));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unknownScheme$str() {
        return "UT001031: Unknown scheme in URI %s";
    }

    @Override
    public final IllegalArgumentException unknownScheme(URI uri) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownScheme$str(), uri));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unknownTransferEncoding$str() {
        return "UT001032: Unknown transfer encoding %s";
    }

    @Override
    public final IOException unknownTransferEncoding(String transferEncodingString) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.unknownTransferEncoding$str(), transferEncodingString));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidConnectionState$str() {
        return "UT001033: Invalid connection state";
    }

    @Override
    public final IOException invalidConnectionState() {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.invalidConnectionState$str(), new Object[0]));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unknownAjpMessageType$str() {
        return "UT001034: Unknown AJP packet type %s";
    }

    @Override
    public final IOException unknownAjpMessageType(byte packetType) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.unknownAjpMessageType$str(), packetType));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unknownMethod$str() {
        return "UT001035: Unknown method type for AJP request %s";
    }

    @Override
    public final IOException unknownMethod(HttpString method) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.unknownMethod$str(), method));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String dataStillRemainingInChunk$str() {
        return "UT001036: Data still remaining in chunk %s";
    }

    @Override
    public final IOException dataStillRemainingInChunk(long remaining) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.dataStillRemainingInChunk$str(), remaining));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String wrongMagicNumber$str() {
        return "UT001037: Wrong magic number, expected %s, actual %s";
    }

    @Override
    public final IOException wrongMagicNumber(String expected, String actual) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.wrongMagicNumber$str(), expected, actual));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String receivedInvalidChunk$str() {
        return "UT001038: Received invalid AJP chunk %s with response already complete";
    }

    @Override
    public final IOException receivedInvalidChunk(byte prefix) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.receivedInvalidChunk$str(), prefix));
        UndertowClientMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }
}

