/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.BufferWritableOutputStream;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.xnio.Buffers;
import org.xnio.IoUtils;

public class BlockingSenderImpl
implements Sender {
    private final HttpServerExchange exchange;
    private final OutputStream outputStream;
    private volatile Thread inCall;
    private volatile Thread sendThread;
    private ByteBuffer[] next;
    private FileChannel pendingFile;
    private IoCallback queuedCallback;

    public BlockingSenderImpl(HttpServerExchange exchange, OutputStream outputStream) {
        this.exchange = exchange;
        this.outputStream = outputStream;
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(new ByteBuffer[]{buffer}, callback);
            return;
        }
        long responseContentLength = this.exchange.getResponseContentLength();
        if (responseContentLength > 0L && (long)buffer.remaining() > responseContentLength) {
            callback.onException(this.exchange, this, UndertowLogger.ROOT_LOGGER.dataLargerThanContentLength(buffer.remaining(), responseContentLength));
            return;
        }
        if (!this.exchange.isResponseStarted() && callback == IoCallback.END_EXCHANGE && responseContentLength == -1L && !this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
            this.exchange.setResponseContentLength(buffer.remaining());
        }
        if (this.writeBuffer(buffer, callback)) {
            this.invokeOnComplete(callback);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(buffer, callback);
            return;
        }
        long responseContentLength = this.exchange.getResponseContentLength();
        if (responseContentLength > 0L && Buffers.remaining(buffer) > responseContentLength) {
            callback.onException(this.exchange, this, UndertowLogger.ROOT_LOGGER.dataLargerThanContentLength(Buffers.remaining(buffer), responseContentLength));
            return;
        }
        if (!this.exchange.isResponseStarted() && callback == IoCallback.END_EXCHANGE && responseContentLength == -1L && !this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
            this.exchange.setResponseContentLength(Buffers.remaining(buffer));
        }
        if (!this.writeBuffer(buffer, callback)) {
            return;
        }
        this.invokeOnComplete(callback);
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(ByteBuffer[] buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data2, IoCallback callback) {
        byte[] bytes = data2.getBytes(StandardCharsets.UTF_8);
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(new ByteBuffer[]{ByteBuffer.wrap(bytes)}, callback);
            return;
        }
        long responseContentLength = this.exchange.getResponseContentLength();
        if (responseContentLength > 0L && (long)bytes.length > responseContentLength) {
            callback.onException(this.exchange, this, UndertowLogger.ROOT_LOGGER.dataLargerThanContentLength(bytes.length, responseContentLength));
            return;
        }
        if (!this.exchange.isResponseStarted() && callback == IoCallback.END_EXCHANGE && responseContentLength == -1L && !this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
            this.exchange.setResponseContentLength(bytes.length);
        }
        try {
            this.outputStream.write(bytes);
            this.invokeOnComplete(callback);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(String data2, Charset charset, IoCallback callback) {
        byte[] bytes = data2.getBytes(charset);
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(new ByteBuffer[]{ByteBuffer.wrap(bytes)}, callback);
            return;
        }
        long responseContentLength = this.exchange.getResponseContentLength();
        if (responseContentLength > 0L && (long)bytes.length > responseContentLength) {
            callback.onException(this.exchange, this, UndertowLogger.ROOT_LOGGER.dataLargerThanContentLength(bytes.length, responseContentLength));
            return;
        }
        if (!this.exchange.isResponseStarted() && callback == IoCallback.END_EXCHANGE && responseContentLength == -1L && !this.exchange.getResponseHeaders().contains(Headers.TRANSFER_ENCODING)) {
            this.exchange.setResponseContentLength(bytes.length);
        }
        try {
            this.outputStream.write(bytes);
            this.invokeOnComplete(callback);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(String data2) {
        this.send(data2, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data2, Charset charset) {
        this.send(data2, charset, IoCallback.END_EXCHANGE);
    }

    @Override
    public void transferFrom(FileChannel source, IoCallback callback) {
        this.sendThread = Thread.currentThread();
        if (this.inCall == Thread.currentThread()) {
            this.queue(source, callback);
            return;
        }
        this.performTransfer(source, callback);
        this.invokeOnComplete(callback);
    }

    private void performTransfer(FileChannel source, IoCallback callback) {
        if (this.outputStream instanceof BufferWritableOutputStream) {
            try {
                ((BufferWritableOutputStream)((Object)this.outputStream)).transferFrom(source);
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
            }
        } else {
            try (PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().getArrayBackedPool().allocate();){
                int ret;
                ByteBuffer buffer = pooled.getBuffer();
                long pos = source.position();
                long size = source.size();
                while (size - pos > 0L && (ret = source.read(buffer)) > 0) {
                    pos += (long)ret;
                    this.outputStream.write(buffer.array(), buffer.arrayOffset(), ret);
                    buffer.clear();
                }
                if (pos != size) {
                    throw new EOFException("Unexpected EOF reading file");
                }
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
            }
        }
    }

    @Override
    public void close(IoCallback callback) {
        try {
            this.outputStream.close();
            this.invokeOnComplete(callback);
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void close() {
        IoUtils.safeClose((Closeable)this.outputStream);
    }

    private boolean writeBuffer(ByteBuffer buffer, IoCallback callback) {
        return this.writeBuffer(new ByteBuffer[]{buffer}, callback);
    }

    private boolean writeBuffer(ByteBuffer[] buffers, IoCallback callback) {
        if (this.outputStream instanceof BufferWritableOutputStream) {
            try {
                ((BufferWritableOutputStream)((Object)this.outputStream)).write(buffers);
                return true;
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
                return false;
            }
        }
        for (ByteBuffer buffer : buffers) {
            if (buffer.hasArray()) {
                try {
                    this.outputStream.write(buffer.array(), buffer.arrayOffset(), buffer.remaining());
                    continue;
                }
                catch (IOException e) {
                    callback.onException(this.exchange, this, e);
                    return false;
                }
            }
            try (PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().getArrayBackedPool().allocate();){
                while (buffer.hasRemaining()) {
                    int toRead = Math.min(buffer.remaining(), pooled.getBuffer().remaining());
                    buffer.get(pooled.getBuffer().array(), pooled.getBuffer().arrayOffset(), toRead);
                    try {
                        this.outputStream.write(pooled.getBuffer().array(), pooled.getBuffer().arrayOffset(), toRead);
                    }
                    catch (IOException e) {
                        callback.onException(this.exchange, this, e);
                        boolean bl = false;
                        if (pooled != null) {
                            if (var8_10 != null) {
                                try {
                                    pooled.close();
                                }
                                catch (Throwable throwable) {
                                    var8_10.addSuppressed(throwable);
                                }
                            } else {
                                pooled.close();
                            }
                        }
                        return bl;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete(IoCallback callback) {
        this.sendThread = null;
        this.inCall = Thread.currentThread();
        try {
            callback.onComplete(this.exchange, this);
        }
        finally {
            this.inCall = null;
        }
        if (Thread.currentThread() != this.sendThread) {
            return;
        }
        while (this.next != null || this.pendingFile != null) {
            ByteBuffer[] next = this.next;
            IoCallback queuedCallback = this.queuedCallback;
            FileChannel file = this.pendingFile;
            this.next = null;
            this.queuedCallback = null;
            this.pendingFile = null;
            if (next != null) {
                for (ByteBuffer buffer : next) {
                    this.writeBuffer(buffer, queuedCallback);
                }
            } else if (file != null) {
                this.performTransfer(file, queuedCallback);
            }
            this.sendThread = null;
            this.inCall = Thread.currentThread();
            try {
                queuedCallback.onComplete(this.exchange, this);
            }
            finally {
                this.inCall = null;
            }
            if (Thread.currentThread() == this.sendThread) continue;
            return;
        }
    }

    private void queue(ByteBuffer[] byteBuffers, IoCallback ioCallback) {
        if (this.next != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.next = byteBuffers;
        this.queuedCallback = ioCallback;
    }

    private void queue(FileChannel source, IoCallback ioCallback) {
        if (this.pendingFile != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.pendingFile = source;
        this.queuedCallback = ioCallback;
    }
}

