/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;

class AndPredicate
implements Predicate {
    private final Predicate[] predicates;

    AndPredicate(Predicate ... predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        for (Predicate predicate : this.predicates) {
            if (predicate.resolve(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (Predicate predicate : this.predicates) {
            if (result2.length() > 0) {
                result2.append(" and ");
            }
            result2.append(predicate.toString());
        }
        return result2.toString();
    }
}

