/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.ConnectionErrorException;
import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.HpackException;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import io.undertow.protocols.http2.StreamErrorException;
import io.undertow.server.Connectors;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xnio.Bits;

abstract class Http2HeaderBlockParser
extends Http2PushBackParser
implements HpackDecoder.HeaderEmitter {
    private final HeaderMap headerMap = new HeaderMap();
    private boolean beforeHeadersHandled = false;
    private final HpackDecoder decoder;
    private int frameRemaining = -1;
    private boolean invalid = false;
    private boolean processingPseudoHeaders = true;
    private final boolean client;
    private final int maxHeaders;
    private final int maxHeaderListSize;
    private int currentPadding;
    private final int streamId;
    private int headerSize;
    private static final Set<HttpString> SERVER_HEADERS;

    Http2HeaderBlockParser(int frameLength, HpackDecoder decoder, boolean client, int maxHeaders, int streamId, int maxHeaderListSize) {
        super(frameLength);
        this.decoder = decoder;
        this.client = client;
        this.maxHeaders = maxHeaders;
        this.streamId = streamId;
        this.maxHeaderListSize = maxHeaderListSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser header) throws IOException {
        boolean continuationFramesComing = Bits.anyAreClear(header.flags, 4);
        if (this.frameRemaining == -1) {
            this.frameRemaining = header.length;
        }
        boolean moreDataThisFrame = resource.remaining() < this.frameRemaining;
        int pos = resource.position();
        int readInBeforeHeader = 0;
        try {
            if (!this.beforeHeadersHandled) {
                if (!this.handleBeforeHeader(resource, header)) {
                    return;
                }
                this.currentPadding = this.getPaddingLength();
                readInBeforeHeader = resource.position() - pos;
            }
            this.beforeHeadersHandled = true;
            this.decoder.setHeaderEmitter(this);
            int oldLimit = -1;
            if (this.currentPadding > 0) {
                int actualData = this.frameRemaining - readInBeforeHeader - this.currentPadding;
                if (actualData < 0) {
                    throw new ConnectionErrorException(1);
                }
                if (resource.remaining() > actualData) {
                    oldLimit = resource.limit();
                    resource.limit(resource.position() + actualData);
                }
            }
            try {
                this.decoder.decode(resource, moreDataThisFrame || continuationFramesComing);
            }
            catch (HpackException e) {
                throw new ConnectionErrorException(e.getCloseCode(), (Throwable)e);
            }
            if (this.maxHeaders > 0 && this.headerMap.size() > this.maxHeaders) {
                throw new StreamErrorException(6);
            }
            if (oldLimit != -1) {
                if (resource.remaining() == 0) {
                    int paddingInBuffer = oldLimit - resource.limit();
                    this.currentPadding -= paddingInBuffer;
                    resource.limit(oldLimit);
                    resource.position(oldLimit);
                } else {
                    resource.limit(oldLimit);
                }
            }
        }
        finally {
            int used = resource.position() - pos;
            this.frameRemaining -= used;
        }
    }

    protected abstract boolean handleBeforeHeader(ByteBuffer var1, Http2FrameHeaderParser var2);

    HeaderMap getHeaderMap() {
        return this.headerMap;
    }

    @Override
    public void emitHeader(HttpString name, String value, boolean neverIndex) throws HpackException {
        if (this.maxHeaderListSize > 0) {
            this.headerSize += name.length() + value.length() + 32;
            if (this.headerSize > this.maxHeaderListSize) {
                throw new HpackException(UndertowMessages.MESSAGES.headerBlockTooLarge(), 1);
            }
        }
        if (this.maxHeaders > 0 && this.headerMap.size() > this.maxHeaders) {
            return;
        }
        this.headerMap.add(name, value);
        if (name.length() == 0) {
            throw UndertowMessages.MESSAGES.invalidHeader();
        }
        if (name.equals(Headers.TRANSFER_ENCODING)) {
            throw new HpackException(1);
        }
        if (name.byteAt(0) == 58) {
            if (this.client) {
                if (!name.equals(Http2Channel.STATUS)) {
                    this.invalid = true;
                }
            } else if (!SERVER_HEADERS.contains(name)) {
                this.invalid = true;
            }
            if (!this.processingPseudoHeaders) {
                throw new HpackException(UndertowMessages.MESSAGES.pseudoHeaderInWrongOrder(name), 1);
            }
        } else {
            this.processingPseudoHeaders = false;
        }
        for (int i = 0; i < name.length(); ++i) {
            byte c = name.byteAt(i);
            if (c >= 65 && c <= 90) {
                this.invalid = true;
                UndertowLogger.REQUEST_LOGGER.debugf("Malformed request, header %s contains uppercase characters", (Object)name);
                continue;
            }
            if (c == 58 || Connectors.isValidTokenCharacter(c)) continue;
            this.invalid = true;
            UndertowLogger.REQUEST_LOGGER.debugf("Malformed request, header %s contains invalid token character", (Object)name);
        }
    }

    protected abstract int getPaddingLength();

    @Override
    protected void moreData(int data2) {
        super.moreData(data2);
        this.frameRemaining += data2;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public int getStreamId() {
        return this.streamId;
    }

    static {
        HashSet<HttpString> server = new HashSet<HttpString>();
        server.add(Http2Channel.METHOD);
        server.add(Http2Channel.AUTHORITY);
        server.add(Http2Channel.SCHEME);
        server.add(Http2Channel.PATH);
        SERVER_HEADERS = Collections.unmodifiableSet(server);
    }
}

