/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.util.HexConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.xnio.SslClientAuthMode;

public class BasicSSLSessionInfo
implements SSLSessionInfo {
    private final byte[] sessionId;
    private final String cypherSuite;
    private final Certificate[] peerCertificate;
    private final X509Certificate[] certificate;
    private final Integer keySize;

    public BasicSSLSessionInfo(byte[] sessionId, String cypherSuite, String certificate, Integer keySize) throws java.security.cert.CertificateException, CertificateException {
        this.sessionId = sessionId;
        this.cypherSuite = cypherSuite;
        this.keySize = keySize;
        if (certificate != null) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            byte[] certificateBytes = certificate.getBytes(StandardCharsets.US_ASCII);
            ByteArrayInputStream stream = new ByteArrayInputStream(certificateBytes);
            Collection<? extends Certificate> certCol = cf.generateCertificates(stream);
            this.peerCertificate = new Certificate[certCol.size()];
            X509Certificate[] legacyCertificate = new X509Certificate[certCol.size()];
            int i = 0;
            Iterator<? extends Certificate> iterator2 = certCol.iterator();
            while (iterator2.hasNext()) {
                Certificate cert;
                this.peerCertificate[i] = cert = iterator2.next();
                if (legacyCertificate != null) {
                    try {
                        legacyCertificate[i] = X509Certificate.getInstance(cert.getEncoded());
                    }
                    catch (CertificateException ce) {
                        legacyCertificate = null;
                    }
                }
                ++i;
            }
            this.certificate = legacyCertificate;
        } else {
            this.peerCertificate = null;
            this.certificate = null;
        }
    }

    public BasicSSLSessionInfo(byte[] sessionId, String cypherSuite, String certificate) throws java.security.cert.CertificateException, CertificateException {
        this(sessionId, cypherSuite, certificate, null);
    }

    public BasicSSLSessionInfo(String sessionId, String cypherSuite, String certificate) throws java.security.cert.CertificateException, CertificateException {
        this(sessionId == null ? null : BasicSSLSessionInfo.fromHex(sessionId), cypherSuite, certificate, null);
    }

    public BasicSSLSessionInfo(String sessionId, String cypherSuite, String certificate, Integer keySize) throws java.security.cert.CertificateException, CertificateException {
        this(sessionId == null ? null : BasicSSLSessionInfo.fromHex(sessionId), cypherSuite, certificate, keySize);
    }

    @Override
    public byte[] getSessionId() {
        if (this.sessionId == null) {
            return null;
        }
        byte[] copy2 = new byte[this.sessionId.length];
        System.arraycopy(this.sessionId, 0, copy2, 0, copy2.length);
        return copy2;
    }

    @Override
    public String getCipherSuite() {
        return this.cypherSuite;
    }

    @Override
    public int getKeySize() {
        if (this.keySize != null) {
            return this.keySize;
        }
        return SSLSessionInfo.super.getKeySize();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCertificate == null) {
            throw UndertowMessages.MESSAGES.peerUnverified();
        }
        return this.peerCertificate;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.certificate == null) {
            throw UndertowMessages.MESSAGES.peerUnverified();
        }
        return this.certificate;
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        throw UndertowMessages.MESSAGES.renegotiationNotSupported();
    }

    @Override
    public SSLSession getSSLSession() {
        return null;
    }

    private static byte[] fromHex(String sessionId) {
        try {
            return HexConverter.convertFromHex(sessionId);
        }
        catch (Exception e) {
            return null;
        }
    }
}

