/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeEvent;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedFilters;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.ManagedServlets;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.FilterHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatchesData;
import io.undertow.servlet.handlers.security.ServletSecurityRoleHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.http.MappingMatch;

public class ServletPathMatches {
    public static final String DEFAULT_SERVLET_NAME = "default";
    private final Deployment deployment;
    private volatile String[] welcomePages;
    private final ResourceManager resourceManager;
    private volatile ServletPathMatchesData data;
    private final LRUCache<String, ServletPathMatch> pathMatchCacheFixed;
    private final LRUCache<String, ServletPathMatch> pathMatchCacheResources;

    public ServletPathMatches(Deployment deployment) {
        this.deployment = deployment;
        this.welcomePages = deployment.getDeploymentInfo().getWelcomePages().toArray(new String[deployment.getDeploymentInfo().getWelcomePages().size()]);
        this.resourceManager = deployment.getDeploymentInfo().getResourceManager();
        this.pathMatchCacheFixed = new LRUCache(1000, -1, true);
        this.pathMatchCacheResources = new LRUCache(1000, this.resourceManager instanceof CachingResourceManager ? ((CachingResourceManager)this.resourceManager).getMaxAge() : -1, true);
        if (this.resourceManager.isResourceChangeListenerSupported()) {
            try {
                this.resourceManager.registerResourceChangeListener(new ResourceChangeListener(){

                    @Override
                    public void handleChanges(Collection<ResourceChangeEvent> changes) {
                        for (ResourceChangeEvent change : changes) {
                            if (change.getType() == ResourceChangeEvent.Type.MODIFIED) continue;
                            String path = "/" + change.getResource();
                            ServletPathMatches.this.pathMatchCacheResources.remove(path);
                            ServletPathMatches.this.pathMatchCacheResources.remove(path + "/");
                            for (String welcomePage : ServletPathMatches.this.welcomePages) {
                                if (!path.endsWith("/" + welcomePage)) continue;
                                String pathToUpdate = path.substring(0, path.length() - welcomePage.length());
                                ServletPathMatches.this.pathMatchCacheResources.remove(pathToUpdate);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.couldNotRegisterChangeListener(e);
            }
        }
    }

    public void initData() {
        this.getData();
    }

    public ServletChain getServletHandlerByName(String name) {
        return this.getData().getServletHandlerByName(name);
    }

    public ServletPathMatch getServletHandlerByPath(String path) {
        ServletPathMatch existing = this.pathMatchCacheFixed.get(path);
        if (existing == null) {
            existing = this.pathMatchCacheResources.get(path);
        }
        if (existing != null) {
            return existing;
        }
        ServletPathMatch match = this.getData().getServletHandlerByPath(path);
        if (!match.isRequiredWelcomeFileMatch()) {
            this.pathMatchCacheFixed.add(path, match);
            return match;
        }
        try {
            String remaining = match.getRemaining() == null ? match.getMatched() : match.getRemaining();
            Resource resource = this.resourceManager.getResource(remaining);
            if (resource == null || !resource.isDirectory()) {
                this.pathMatchCacheResources.add(path, match);
                return match;
            }
            boolean pathEndsWithSlash = remaining.endsWith("/");
            String pathWithTrailingSlash = pathEndsWithSlash ? remaining : remaining + "/";
            ServletPathMatch welcomePage = this.findWelcomeFile(pathWithTrailingSlash, !pathEndsWithSlash);
            if (welcomePage != null) {
                this.pathMatchCacheResources.add(path, welcomePage);
                return welcomePage;
            }
            welcomePage = this.findWelcomeServlet(pathWithTrailingSlash, !pathEndsWithSlash);
            if (welcomePage != null) {
                this.pathMatchCacheResources.add(path, welcomePage);
                return welcomePage;
            }
            if (pathEndsWithSlash) {
                this.pathMatchCacheResources.add(path, match);
                return match;
            }
            ServletPathMatch redirect = new ServletPathMatch(match.getServletChain(), match.getMatched(), match.getRemaining(), ServletPathMatch.Type.REDIRECT, "/");
            this.pathMatchCacheResources.add(path, redirect);
            return redirect;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void invalidate() {
        this.data = null;
        this.pathMatchCacheResources.clear();
        this.pathMatchCacheFixed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletPathMatchesData getData() {
        ServletPathMatchesData data2 = this.data;
        if (data2 != null) {
            return data2;
        }
        ServletPathMatches servletPathMatches = this;
        synchronized (servletPathMatches) {
            if (this.data != null) {
                return this.data;
            }
            this.data = this.setupServletChains();
            return this.data;
        }
    }

    private ServletPathMatch findWelcomeFile(String path, boolean requiresRedirect) {
        if (File.separatorChar != '/' && path.contains(File.separator)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String i : this.welcomePages) {
            try {
                sb.append(path);
                sb.append(i);
                String mergedPath = sb.toString();
                sb.setLength(0);
                Resource resource = this.resourceManager.getResource(mergedPath);
                if (resource == null) continue;
                ServletPathMatch handler = this.data.getServletHandlerByPath(mergedPath);
                return new ServletPathMatch(handler.getServletChain(), mergedPath, null, requiresRedirect ? ServletPathMatch.Type.REDIRECT : ServletPathMatch.Type.REWRITE, mergedPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private ServletPathMatch findWelcomeServlet(String path, boolean requiresRedirect) {
        StringBuilder sb = new StringBuilder();
        for (String i : this.welcomePages) {
            sb.append(path);
            sb.append(i);
            String mergedPath = sb.toString();
            sb.setLength(0);
            ServletPathMatch handler = this.data.getServletHandlerByPath(mergedPath);
            if (handler == null || handler.isRequiredWelcomeFileMatch()) continue;
            return new ServletPathMatch(handler.getServletChain(), handler.getMatched(), handler.getRemaining(), requiresRedirect ? ServletPathMatch.Type.REDIRECT : ServletPathMatch.Type.REWRITE, mergedPath);
        }
        return null;
    }

    public void setWelcomePages(List<String> welcomePages) {
        this.welcomePages = welcomePages.toArray(new String[welcomePages.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private ServletPathMatchesData setupServletChains() {
        ServletHandler defaultServlet = null;
        ManagedServlets servlets = this.deployment.getServlets();
        ManagedFilters filters = this.deployment.getFilters();
        HashMap<String, ServletHandler> extensionServlets = new HashMap<String, ServletHandler>();
        HashMap<String, ServletHandler> pathServlets = new HashMap<String, ServletHandler>();
        HashSet<String> pathMatches = new HashSet<String>();
        HashSet<String> extensionMatches = new HashSet<String>();
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
            if (filterMappingInfo.getMappingType() != FilterMappingInfo.MappingType.URL) continue;
            String path = filterMappingInfo.getMapping();
            if (path.equals("*")) {
                path = "/*";
            }
            if (!path.startsWith("*.")) {
                pathMatches.add(path);
                continue;
            }
            extensionMatches.add(path.substring(2));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            ServletHandler handler = (ServletHandler)entry.getValue();
            for (String path : handler.getManagedServlet().getServletInfo().getMappings()) {
                if (path.equals("/")) {
                    pathMatches.add("/*");
                    if (defaultServlet != null) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    defaultServlet = handler;
                    continue;
                }
                if (!path.startsWith("*.")) {
                    if (path.isEmpty()) {
                        path = "/";
                    }
                    pathMatches.add(path);
                    if (pathServlets.containsKey(path)) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    pathServlets.put(path, handler);
                    continue;
                }
                String ext = path.substring(2);
                extensionMatches.add(ext);
                if (extensionServlets.containsKey(ext)) {
                    throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                }
                extensionServlets.put(ext, handler);
            }
        }
        ServletHandler managedDefaultServlet = servlets.getServletHandler(DEFAULT_SERVLET_NAME);
        if (managedDefaultServlet == null) {
            managedDefaultServlet = servlets.addServlet(new ServletInfo(DEFAULT_SERVLET_NAME, DefaultServlet.class));
        }
        if (defaultServlet == null) {
            pathMatches.add("/*");
            defaultServlet = managedDefaultServlet;
        }
        ServletPathMatchesData.Builder builder = ServletPathMatchesData.builder();
        for (String string : pathMatches) {
            void var17_32;
            MatchData targetServletMatch = ServletPathMatches.resolveServletForPath(string, pathServlets, extensionServlets, defaultServlet);
            EnumMap<DispatcherType, List<ManagedFilter>> noExtension = new EnumMap<DispatcherType, List<ManagedFilter>>(DispatcherType.class);
            HashMap extension = new HashMap();
            for (String string2 : extensionMatches) {
                extension.put(string2, new EnumMap(DispatcherType.class));
            }
            for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMappingInfo.getFilterName());
                if (filterMappingInfo.getMappingType() == FilterMappingInfo.MappingType.SERVLET) {
                    if (targetServletMatch.handler != null && (filterMappingInfo.getMapping().equals(targetServletMatch.handler.getManagedServlet().getServletInfo().getName()) || filterMappingInfo.getMapping().equals("*"))) {
                        ServletPathMatches.addToListMap(noExtension, filterMappingInfo.getDispatcher(), filter);
                    }
                    for (Map.Entry entry : extension.entrySet()) {
                        ServletHandler pathServlet = targetServletMatch.handler;
                        boolean defaultServletMatch = targetServletMatch.defaultServlet;
                        if (defaultServletMatch && extensionServlets.containsKey(entry.getKey())) {
                            pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                        }
                        if (!filterMappingInfo.getMapping().equals(pathServlet.getManagedServlet().getServletInfo().getName()) && !filterMappingInfo.getMapping().equals("*")) continue;
                        ServletPathMatches.addToListMap((Map)extension.get(entry.getKey()), filterMappingInfo.getDispatcher(), filter);
                    }
                    continue;
                }
                if (filterMappingInfo.getMapping().isEmpty() || !filterMappingInfo.getMapping().startsWith("*.")) {
                    if (!ServletPathMatches.isFilterApplicable(string, filterMappingInfo.getMapping())) continue;
                    ServletPathMatches.addToListMap(noExtension, filterMappingInfo.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        ServletPathMatches.addToListMap(l, filterMappingInfo.getDispatcher(), filter);
                    }
                    continue;
                }
                ServletPathMatches.addToListMap((Map)extension.get(filterMappingInfo.getMapping().substring(2)), filterMappingInfo.getDispatcher(), filter);
            }
            if (string.endsWith("/*")) {
                String prefix = string.substring(0, string.length() - 2);
                builder.addPrefixMatch(prefix, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath), targetServletMatch.defaultServlet || targetServletMatch.handler.getManagedServlet().getServletInfo().isRequireWelcomeFileMapping());
                for (Map.Entry entry : extension.entrySet()) {
                    MappingMatch mappingMatch;
                    String servletMatchPattern;
                    boolean defaultServletMatch;
                    ServletHandler pathServlet = targetServletMatch.handler;
                    String pathMatch = targetServletMatch.matchedPath;
                    if (targetServletMatch.defaultServlet) {
                        ServletHandler extensionServletHandler = (ServletHandler)extensionServlets.get(entry.getKey());
                        if (extensionServletHandler != null) {
                            defaultServletMatch = false;
                            pathServlet = extensionServletHandler;
                            servletMatchPattern = "*." + (String)entry.getKey();
                            mappingMatch = MappingMatch.EXTENSION;
                        } else {
                            defaultServletMatch = true;
                            servletMatchPattern = "/";
                            mappingMatch = MappingMatch.DEFAULT;
                        }
                    } else {
                        defaultServletMatch = false;
                        servletMatchPattern = string;
                        mappingMatch = MappingMatch.PATH;
                    }
                    HttpHandler handler = pathServlet;
                    if (!((Map)entry.getValue()).isEmpty()) {
                        handler = new FilterHandler((Map)entry.getValue(), deploymentInfo.isAllowNonStandardWrappers(), handler);
                    }
                    builder.addExtensionMatch(prefix, (String)entry.getKey(), ServletPathMatches.servletChain(handler, pathServlet.getManagedServlet(), (Map)entry.getValue(), pathMatch, deploymentInfo, defaultServletMatch, mappingMatch, servletMatchPattern));
                }
                continue;
            }
            if (string.isEmpty()) {
                builder.addExactMatch("/", this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
                continue;
            }
            int lastSegmentIndex = string.lastIndexOf(47);
            if (lastSegmentIndex > 0) {
                String string3 = string.substring(lastSegmentIndex);
            } else {
                String string4 = string;
            }
            if (var17_32.contains(".")) {
                String ext = var17_32.substring(var17_32.lastIndexOf(46) + 1);
                if (extension.containsKey(ext)) {
                    Map extMap = (Map)extension.get(ext);
                    builder.addExactMatch(string, this.createHandler(deploymentInfo, targetServletMatch.handler, extMap, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
                    continue;
                }
                builder.addExactMatch(string, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
                continue;
            }
            builder.addExactMatch(string, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            EnumMap<DispatcherType, List<ManagedFilter>> filtersByDispatcher = new EnumMap<DispatcherType, List<ManagedFilter>>(DispatcherType.class);
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !filterMapping.getMapping().equals(entry.getKey())) continue;
                ServletPathMatches.addToListMap(filtersByDispatcher, filterMapping.getDispatcher(), filter);
            }
            if (filtersByDispatcher.isEmpty()) {
                builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain((HttpHandler)entry.getValue(), ((ServletHandler)entry.getValue()).getManagedServlet(), filtersByDispatcher, null, deploymentInfo, false, MappingMatch.EXACT, ""));
                continue;
            }
            builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain(new FilterHandler(filtersByDispatcher, deploymentInfo.isAllowNonStandardWrappers(), (HttpHandler)entry.getValue()), ((ServletHandler)entry.getValue()).getManagedServlet(), filtersByDispatcher, null, deploymentInfo, false, MappingMatch.EXACT, ""));
        }
        return builder.build();
    }

    private ServletChain createHandler(DeploymentInfo deploymentInfo, ServletHandler targetServlet, Map<DispatcherType, List<ManagedFilter>> noExtension, String servletPath, boolean defaultServlet, MappingMatch mappingMatch, String pattern) {
        ServletChain initialHandler;
        if (noExtension.isEmpty()) {
            initialHandler = ServletPathMatches.servletChain(targetServlet, targetServlet.getManagedServlet(), noExtension, servletPath, deploymentInfo, defaultServlet, mappingMatch, pattern);
        } else {
            FilterHandler handler = new FilterHandler(noExtension, deploymentInfo.isAllowNonStandardWrappers(), targetServlet);
            initialHandler = ServletPathMatches.servletChain(handler, targetServlet.getManagedServlet(), noExtension, servletPath, deploymentInfo, defaultServlet, mappingMatch, pattern);
        }
        return initialHandler;
    }

    private static MatchData resolveServletForPath(String path, Map<String, ServletHandler> pathServlets, Map<String, ServletHandler> extensionServlets, ServletHandler defaultServlet) {
        String ext;
        if (pathServlets.containsKey(path)) {
            if (path.endsWith("/*")) {
                String base = path.substring(0, path.length() - 2);
                return new MatchData(pathServlets.get(path), base, path, MappingMatch.PATH, false);
            }
            if (path.equals("/")) {
                return new MatchData(pathServlets.get(path), path, "", MappingMatch.CONTEXT_ROOT, false);
            }
            return new MatchData(pathServlets.get(path), path, path, MappingMatch.EXACT, false);
        }
        String match = null;
        ServletHandler servlet = null;
        String userPath = "";
        for (Map.Entry<String, ServletHandler> entry : pathServlets.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("/*")) continue;
            String base = key.substring(0, key.length() - 1);
            if (match != null && base.length() <= match.length() || !path.startsWith(base) && !path.equals(base.substring(0, base.length() - 1))) continue;
            match = base.substring(0, base.length() - 1);
            servlet = entry.getValue();
            userPath = key;
        }
        if (servlet != null) {
            return new MatchData(servlet, match, userPath, MappingMatch.PATH, false);
        }
        int index = path.lastIndexOf(46);
        if (index != -1 && (servlet = extensionServlets.get(ext = path.substring(index + 1))) != null) {
            return new MatchData(servlet, null, "*." + ext, MappingMatch.EXTENSION, false);
        }
        return new MatchData(defaultServlet, null, "/", MappingMatch.DEFAULT, true);
    }

    private static boolean isFilterApplicable(String path, String filterPath) {
        String modifiedPath = filterPath.equals("*") ? "/*" : filterPath;
        if (path.isEmpty()) {
            return modifiedPath.equals("/*") || modifiedPath.equals("/");
        }
        if (modifiedPath.endsWith("/*")) {
            String baseFilterPath = modifiedPath.substring(0, modifiedPath.length() - 1);
            String exactFilterPath = modifiedPath.substring(0, modifiedPath.length() - 2);
            return path.startsWith(baseFilterPath) || path.equals(exactFilterPath);
        }
        return modifiedPath.equals(path);
    }

    private static <K, V> void addToListMap(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }

    private static ServletChain servletChain(HttpHandler next, ManagedServlet managedServlet, Map<DispatcherType, List<ManagedFilter>> filters, String servletPath, DeploymentInfo deploymentInfo, boolean defaultServlet, MappingMatch mappingMatch, String pattern) {
        HttpHandler servletHandler = next;
        if (!deploymentInfo.isSecurityDisabled()) {
            servletHandler = new ServletSecurityRoleHandler(servletHandler, deploymentInfo.getAuthorizationManager());
        }
        servletHandler = ServletPathMatches.wrapHandlers(servletHandler, managedServlet.getServletInfo().getHandlerChainWrappers());
        return new ServletChain(servletHandler, managedServlet, servletPath, defaultServlet, mappingMatch, pattern, filters);
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    private static class MatchData {
        final ServletHandler handler;
        final String matchedPath;
        final String userPath;
        final MappingMatch mappingMatch;
        final boolean defaultServlet;

        private MatchData(ServletHandler handler, String matchedPath, String userPath, MappingMatch mappingMatch, boolean defaultServlet) {
            this.handler = handler;
            this.matchedPath = matchedPath;
            this.userPath = userPath;
            this.mappingMatch = mappingMatch;
            this.defaultServlet = defaultServlet;
        }
    }
}

