/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;

public class WorkerUtils {
    private WorkerUtils() {
    }

    public static XnioExecutor.Key executeAfter(XnioIoThread thread2, Runnable task, long timeout, TimeUnit timeUnit) {
        try {
            return thread2.executeAfter(task, timeout, timeUnit);
        }
        catch (RejectedExecutionException e) {
            if (thread2.getWorker().isShutdown()) {
                UndertowLogger.ROOT_LOGGER.debugf((Throwable)e, "Failed to schedule task %s as worker is shutting down", (Object)task);
                return new XnioExecutor.Key(){

                    @Override
                    public boolean remove() {
                        return false;
                    }
                };
            }
            throw e;
        }
    }
}

