/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.function;

import io.undertow.websockets.core.function.ChannelFunction;
import io.undertow.websockets.core.function.ChannelFunctionReadableByteChannel;
import io.undertow.websockets.core.function.ChannelFunctionWritableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ChannelFunctionFileChannel
extends FileChannel {
    private final ChannelFunction[] functions;
    private final FileChannel channel;

    public ChannelFunctionFileChannel(FileChannel channel, ChannelFunction ... functions2) {
        this.channel = channel;
        this.functions = functions2;
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.channel.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.channel.map(mode, position, size);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.channel.lock(position, size, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.channel.tryLock(position, size, shared);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        this.beforeWriting(src);
        return this.channel.write(src, position);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int pos = dst.position();
        int r = this.channel.read(dst);
        if (r > 0) {
            this.afterReading(dst, pos, r);
        }
        return r;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int[] positions = new int[length];
        for (int i = 0; i < positions.length; ++i) {
            positions[i] = dsts[i].position();
        }
        long r = this.channel.read(dsts, offset, length);
        if (r > 0L) {
            for (int i = offset; i < length; ++i) {
                ByteBuffer dst = dsts[i];
                this.afterReading(dst, positions[i], dst.position());
            }
        }
        return r;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.beforeWriting(src);
        return this.channel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            this.beforeWriting(srcs[i]);
        }
        return this.channel.write(srcs, offset, length);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        int pos = dst.position();
        int r = this.channel.read(dst, position);
        if (r > 0) {
            this.afterReading(dst, pos, r);
        }
        return r;
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.channel.transferTo(position, count, new ChannelFunctionWritableByteChannel(target, this.functions));
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this.channel.transferFrom(new ChannelFunctionReadableByteChannel(this.channel, this.functions), position, count);
    }

    private void beforeWriting(ByteBuffer buffer) throws IOException {
        for (ChannelFunction func : this.functions) {
            int pos = buffer.position();
            func.beforeWrite(buffer, pos, buffer.limit() - pos);
        }
    }

    private void afterReading(ByteBuffer buffer, int position, int length) throws IOException {
        for (ChannelFunction func : this.functions) {
            func.afterRead(buffer, position, length);
        }
    }
}

