/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.function;

import io.undertow.websockets.core.function.ChannelFunction;
import io.undertow.websockets.core.function.ChannelFunctionFileChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class ChannelFunctionStreamSourceChannel
implements StreamSourceChannel {
    private final StreamSourceChannel channel;
    private final ChannelFunction[] functions;

    public ChannelFunctionStreamSourceChannel(StreamSourceChannel channel, ChannelFunction ... functions2) {
        this.channel = channel;
        this.functions = functions2;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.channel.transferTo(position, count, new ChannelFunctionFileChannel(target, this.functions));
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return target.transferFrom(this, count, throughBuffer);
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.channel.getReadSetter();
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.channel.getCloseSetter();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int i;
        long r = 0L;
        for (int a = offset; a < length && (i = this.read(dsts[a])) >= 1; ++a) {
            r += (long)i;
        }
        return r;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        ByteBuffer buf;
        int i;
        long r = 0L;
        ByteBuffer[] byteBufferArray = dsts;
        int n = byteBufferArray.length;
        for (int j = 0; j < n && (i = this.read(buf = byteBufferArray[j])) >= 1; ++j) {
            r += (long)i;
        }
        return r;
    }

    @Override
    public void suspendReads() {
        this.channel.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.channel.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.channel.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.channel.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.channel.shutdownReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.channel.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.channel.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.channel.getReadThread();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int position = dst.position();
        int r = this.channel.read(dst);
        if (r > 0) {
            this.afterReading(dst, position, r);
        }
        return r;
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IOException {
        return this.channel.setOption(option, value);
    }

    private void afterReading(ByteBuffer buffer, int position, int length) throws IOException {
        for (ChannelFunction func : this.functions) {
            func.afterRead(buffer, position, length);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

