/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.core.BinaryOutputStream;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.SendHandlerAdapter;
import io.undertow.websockets.jsr.SendResultFuture;
import io.undertow.websockets.jsr.UndertowSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.xnio.channels.Channels;

final class WebSocketSessionRemoteEndpoint
implements RemoteEndpoint {
    private final UndertowSession undertowSession;
    private final RemoteEndpoint.Async async = new AsyncWebSocketSessionRemoteEndpoint();
    private final RemoteEndpoint.Basic basic = new BasicWebSocketSessionRemoteEndpoint();
    private final Encoding encoding;

    WebSocketSessionRemoteEndpoint(UndertowSession session, Encoding encoding) {
        this.undertowSession = session;
        this.encoding = encoding;
    }

    public RemoteEndpoint.Async getAsync() {
        return this.async;
    }

    public RemoteEndpoint.Basic getBasic() {
        return this.basic;
    }

    @Override
    public void flushBatch() {
    }

    @Override
    public void setBatchingAllowed(boolean allowed) throws IOException {
    }

    @Override
    public boolean getBatchingAllowed() {
        return false;
    }

    @Override
    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        if (applicationData == null) {
            throw JsrWebSocketMessages.MESSAGES.messageInNull();
        }
        if (applicationData.remaining() > 125) {
            throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
        }
        WebSockets.sendPing(applicationData, this.undertowSession.getWebSocketChannel(), null);
    }

    @Override
    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        if (applicationData == null) {
            throw JsrWebSocketMessages.MESSAGES.messageInNull();
        }
        if (applicationData.remaining() > 125) {
            throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
        }
        WebSockets.sendPong(applicationData, this.undertowSession.getWebSocketChannel(), null);
    }

    class BasicWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Basic {
        private StreamSinkFrameChannel binaryFrameSender;
        private StreamSinkFrameChannel textFrameSender;

        BasicWebSocketSessionRemoteEndpoint() {
        }

        public void assertNotInFragment() {
            if (this.textFrameSender != null || this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
        }

        @Override
        public void sendText(String text) throws IOException {
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.assertNotInFragment();
            WebSockets.sendTextBlocking(text, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
        }

        @Override
        public void sendBinary(ByteBuffer data2) throws IOException {
            if (data2 == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.assertNotInFragment();
            WebSockets.sendBinaryBlocking(data2, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
            data2.clear();
        }

        @Override
        public void sendText(String partialMessage, boolean isLast) throws IOException {
            if (partialMessage == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.textFrameSender == null) {
                this.textFrameSender = WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.TEXT);
            }
            try {
                Channels.writeBlocking(this.textFrameSender, WebSocketUtils.fromUtf8String(partialMessage));
                if (isLast) {
                    this.textFrameSender.shutdownWrites();
                }
                Channels.flushBlocking(this.textFrameSender);
            }
            finally {
                if (isLast) {
                    this.textFrameSender = null;
                }
            }
        }

        @Override
        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            if (partialByte == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (this.textFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.binaryFrameSender == null) {
                this.binaryFrameSender = WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.BINARY);
            }
            try {
                Channels.writeBlocking(this.binaryFrameSender, partialByte);
                if (isLast) {
                    this.binaryFrameSender.shutdownWrites();
                }
                Channels.flushBlocking(this.binaryFrameSender);
            }
            finally {
                if (isLast) {
                    this.binaryFrameSender = null;
                }
            }
            partialByte.clear();
        }

        @Override
        public OutputStream getSendStream() throws IOException {
            this.assertNotInFragment();
            return new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.BINARY));
        }

        @Override
        public Writer getSendWriter() throws IOException {
            this.assertNotInFragment();
            return new OutputStreamWriter((OutputStream)new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.TEXT)), StandardCharsets.UTF_8);
        }

        @Override
        public void sendObject(Object data2) throws IOException, EncodeException {
            if (data2 == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.sendObjectImpl(data2);
        }

        private void sendObjectImpl(Object o) throws IOException, EncodeException {
            if (o instanceof String) {
                this.sendText((String)o);
            } else if (o instanceof byte[]) {
                this.sendBinary(ByteBuffer.wrap((byte[])o));
            } else if (o instanceof ByteBuffer) {
                this.sendBinary((ByteBuffer)o);
            } else if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                WebSockets.sendTextBlocking(WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
            } else if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                WebSockets.sendBinaryBlocking(WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
            } else {
                throw new EncodeException(o, "No suitable encoder found");
            }
        }

        @Override
        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        @Override
        public boolean getBatchingAllowed() {
            return false;
        }

        @Override
        public void flushBatch() throws IOException {
        }

        @Override
        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPingBlocking(applicationData, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
        }

        @Override
        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPongBlocking(applicationData, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
        }
    }

    class AsyncWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Async {
        private long sendTimeout = 0L;

        AsyncWebSocketSessionRemoteEndpoint() {
        }

        @Override
        public long getSendTimeout() {
            return this.sendTimeout;
        }

        @Override
        public void setSendTimeout(long timeoutmillis) {
            this.sendTimeout = timeoutmillis;
        }

        @Override
        public void sendText(String text, SendHandler handler) {
            if (handler == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            WebSockets.sendText(text, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback<Void>)new SendHandlerAdapter(handler), this.sendTimeout);
        }

        @Override
        public Future<Void> sendText(String text) {
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            SendResultFuture<Void> future = new SendResultFuture<Void>();
            WebSockets.sendText(text, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), future, this.sendTimeout);
            return future;
        }

        @Override
        public Future<Void> sendBinary(ByteBuffer data2) {
            if (data2 == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            SendResultFuture<Void> future = new SendResultFuture<Void>();
            WebSockets.sendBinary(data2, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), future, this.sendTimeout);
            return future;
        }

        @Override
        public void sendBinary(ByteBuffer data2, SendHandler completion) {
            if (completion == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (data2 == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            WebSockets.sendBinary(data2, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback<Void>)new SendHandlerAdapter(completion), this.sendTimeout);
        }

        @Override
        public Future<Void> sendObject(Object o) {
            if (o == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            SendResultFuture future = new SendResultFuture();
            this.sendObjectImpl(o, future);
            return future;
        }

        @Override
        public void sendObject(Object data2, SendHandler handler) {
            if (handler == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (data2 == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.sendObjectImpl(data2, new SendHandlerAdapter(handler));
        }

        private void sendObjectImpl(Object o, WebSocketCallback callback) {
            block7: {
                try {
                    if (o instanceof String) {
                        WebSockets.sendText((String)o, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback<Void>)callback, this.sendTimeout);
                        break block7;
                    }
                    if (o instanceof byte[]) {
                        WebSockets.sendBinary(ByteBuffer.wrap((byte[])o), WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback<Void>)callback, this.sendTimeout);
                        break block7;
                    }
                    if (o instanceof ByteBuffer) {
                        WebSockets.sendBinary((ByteBuffer)o, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback<Void>)callback, this.sendTimeout);
                        break block7;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                        WebSockets.sendText(WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback<Void>)callback, this.sendTimeout);
                        break block7;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                        WebSockets.sendBinary(WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback<Void>)callback, this.sendTimeout);
                        break block7;
                    }
                    throw new EncodeException(o, "No suitable encoder found");
                }
                catch (Exception e) {
                    callback.onError(WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), null, e);
                }
            }
        }

        @Override
        public void setBatchingAllowed(boolean allowed) throws IOException {
            WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().setRequireExplicitFlush(allowed);
        }

        @Override
        public boolean getBatchingAllowed() {
            return WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().isRequireExplicitFlush();
        }

        @Override
        public void flushBatch() throws IOException {
            WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().flush();
        }

        @Override
        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPing(applicationData, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), null, this.sendTimeout);
        }

        @Override
        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPong(applicationData, WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), null, this.sendTimeout);
        }
    }
}

