/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Arrays;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class ConstraintCheckIssue {
    private final Element element;
    private final AnnotationMirror annotationMirror;
    private final IssueKind kind;
    private final String messageKey;
    private final Object[] messageParameters;

    public ConstraintCheckIssue(Element element, AnnotationMirror annotationMirror, IssueKind kind, String messageKey, Object ... messageParameters) {
        this.element = element;
        this.annotationMirror = annotationMirror;
        this.kind = kind;
        this.messageKey = messageKey;
        this.messageParameters = messageParameters;
    }

    public Element getElement() {
        return this.element;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public IssueKind getKind() {
        return this.kind;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Object[] getMessageParameters() {
        return this.messageParameters;
    }

    public boolean isError() {
        return IssueKind.ERROR.equals((Object)this.kind);
    }

    public boolean isWarning() {
        return IssueKind.WARNING.equals((Object)this.kind);
    }

    public static ConstraintCheckIssue error(Element element, AnnotationMirror annotationMirror, String messageKey, Object ... messageParameters) {
        return new ConstraintCheckIssue(element, annotationMirror, IssueKind.ERROR, messageKey, messageParameters);
    }

    public static ConstraintCheckIssue warning(Element element, AnnotationMirror annotationMirror, String messageKey, Object ... messageParameters) {
        return new ConstraintCheckIssue(element, annotationMirror, IssueKind.WARNING, messageKey, messageParameters);
    }

    public String toString() {
        return "ConstraintCheckIssue [annotationMirror=" + this.annotationMirror + ", element=" + this.element + ", kind=" + (Object)((Object)this.kind) + ", messageKey=" + this.messageKey + ", messageParameters=" + Arrays.toString(this.messageParameters) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.annotationMirror == null ? 0 : this.annotationMirror.hashCode());
        result2 = 31 * result2 + (this.element == null ? 0 : this.element.hashCode());
        result2 = 31 * result2 + (this.kind == null ? 0 : this.kind.hashCode());
        result2 = 31 * result2 + (this.messageKey == null ? 0 : this.messageKey.hashCode());
        result2 = 31 * result2 + Arrays.hashCode(this.messageParameters);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintCheckIssue other = (ConstraintCheckIssue)obj;
        if (this.annotationMirror == null ? other.annotationMirror != null : !this.annotationMirror.equals(other.annotationMirror)) {
            return false;
        }
        if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
            return false;
        }
        if (this.kind == null ? other.kind != null : !this.kind.equals((Object)other.kind)) {
            return false;
        }
        if (this.messageKey == null ? other.messageKey != null : !this.messageKey.equals(other.messageKey)) {
            return false;
        }
        return Arrays.equals(this.messageParameters, other.messageParameters);
    }

    public static enum IssueKind {
        WARNING,
        ERROR;

    }
}

