/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import org.hibernate.validator.engine.HibernateValidatorEnhancedBean;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorDescriptor;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class TypeHelper {
    private static final Map<Class<?>, Set<Class<?>>> SUBTYPES_BY_PRIMITIVE;
    private static final int CONSTRAINT_TYPE_INDEX = 0;
    private static final int VALIDATOR_TYPE_INDEX = 1;
    private static final Log LOG;

    private TypeHelper() {
        throw new AssertionError();
    }

    public static boolean isHibernateValidatorEnhancedBean(Class<?> clazz) {
        return HibernateValidatorEnhancedBean.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Type supertype, Type type2) {
        Contracts.assertNotNull(supertype, "supertype");
        Contracts.assertNotNull(type2, "type");
        if (supertype.equals(type2)) {
            return true;
        }
        if (supertype instanceof Class) {
            if (type2 instanceof Class) {
                return TypeHelper.isClassAssignable((Class)supertype, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return TypeHelper.isAssignable(supertype, ((ParameterizedType)type2).getRawType());
            }
            if (type2 instanceof TypeVariable) {
                return TypeHelper.isTypeVariableAssignable(supertype, (TypeVariable)type2);
            }
            if (type2 instanceof GenericArrayType) {
                if (((Class)supertype).isArray()) {
                    return TypeHelper.isAssignable(TypeHelper.getComponentType(supertype), TypeHelper.getComponentType(type2));
                }
                return TypeHelper.isArraySupertype((Class)supertype);
            }
            if (type2 instanceof WildcardType) {
                return TypeHelper.isClassAssignableToWildcardType((Class)supertype, (WildcardType)type2);
            }
            return false;
        }
        if (supertype instanceof ParameterizedType) {
            if (type2 instanceof Class) {
                return TypeHelper.isSuperAssignable(supertype, type2);
            }
            if (type2 instanceof ParameterizedType) {
                return TypeHelper.isParameterizedTypeAssignable((ParameterizedType)supertype, (ParameterizedType)type2);
            }
            return false;
        }
        if (type2 instanceof TypeVariable) {
            return TypeHelper.isTypeVariableAssignable(supertype, (TypeVariable)type2);
        }
        if (supertype instanceof GenericArrayType) {
            if (TypeHelper.isArray(type2)) {
                return TypeHelper.isAssignable(TypeHelper.getComponentType(supertype), TypeHelper.getComponentType(type2));
            }
            return false;
        }
        if (supertype instanceof WildcardType) {
            return TypeHelper.isWildcardTypeAssignable((WildcardType)supertype, type2);
        }
        return false;
    }

    public static Type getErasedType(Type type2) {
        if (type2 instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type2).getRawType();
            return TypeHelper.getErasedType(rawType);
        }
        if (TypeHelper.isArray(type2)) {
            Type componentType = TypeHelper.getComponentType(type2);
            Type erasedComponentType = TypeHelper.getErasedType(componentType);
            return TypeHelper.getArrayType(erasedComponentType);
        }
        if (type2 instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type2).getBounds();
            return TypeHelper.getErasedType(bounds[0]);
        }
        if (type2 instanceof WildcardType) {
            Type[] upperBounds2 = ((WildcardType)type2).getUpperBounds();
            return TypeHelper.getErasedType(upperBounds2[0]);
        }
        return type2;
    }

    public static Class<?> getErasedReferenceType(Type type2) {
        Contracts.assertTrue(TypeHelper.isReferenceType(type2), "type is not a reference type: %s", type2);
        return (Class)TypeHelper.getErasedType(type2);
    }

    public static boolean isArray(Type type2) {
        return type2 instanceof Class && ((Class)type2).isArray() || type2 instanceof GenericArrayType;
    }

    public static Type getComponentType(Type type2) {
        if (type2 instanceof Class) {
            Class klass = (Class)type2;
            return klass.isArray() ? klass.getComponentType() : null;
        }
        if (type2 instanceof GenericArrayType) {
            return ((GenericArrayType)type2).getGenericComponentType();
        }
        return null;
    }

    private static Type getArrayType(Type componentType) {
        Contracts.assertNotNull(componentType, "componentType");
        if (componentType instanceof Class) {
            return Array.newInstance((Class)componentType, 0).getClass();
        }
        return TypeHelper.genericArrayType(componentType);
    }

    public static GenericArrayType genericArrayType(final Type componentType) {
        return new GenericArrayType(){

            @Override
            public Type getGenericComponentType() {
                return componentType;
            }
        };
    }

    public static boolean isInstance(Type type2, Object object) {
        return TypeHelper.getErasedReferenceType(type2).isInstance(object);
    }

    public static ParameterizedType parameterizedType(final Class<?> rawType, final Type ... actualTypeArguments) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return actualTypeArguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    private static Type getResolvedSuperclass(Type type2) {
        Contracts.assertNotNull(type2, "type");
        Class<?> rawType = TypeHelper.getErasedReferenceType(type2);
        Type supertype = rawType.getGenericSuperclass();
        if (supertype == null) {
            return null;
        }
        return TypeHelper.resolveTypeVariables(supertype, type2);
    }

    private static Type[] getResolvedInterfaces(Type type2) {
        Contracts.assertNotNull(type2, "type");
        Class<?> rawType = TypeHelper.getErasedReferenceType(type2);
        Type[] interfaces = rawType.getGenericInterfaces();
        Type[] resolvedInterfaces = new Type[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            resolvedInterfaces[i] = TypeHelper.resolveTypeVariables(interfaces[i], type2);
        }
        return resolvedInterfaces;
    }

    public static <A extends Annotation> Map<Type, ConstraintValidatorDescriptor<A>> getValidatorTypes(Class<A> annotationType, List<ConstraintValidatorDescriptor<A>> validators) {
        HashMap<Type, ConstraintValidatorDescriptor<A>> validatorsTypes = CollectionHelper.newHashMap();
        for (ConstraintValidatorDescriptor<A> validator : validators) {
            Type type2 = validator.getValidatedType();
            ConstraintValidatorDescriptor<A> previous = validatorsTypes.put(type2, validator);
            if (previous == null) continue;
            throw LOG.getMultipleValidatorsForSameTypeException(annotationType, type2, previous.getValidatorClass(), validator.getValidatorClass());
        }
        return validatorsTypes;
    }

    public static Type extractValidatedType(Class<? extends ConstraintValidator<?, ?>> validator) {
        return TypeHelper.extractConstraintValidatorTypeArgumentType(validator, 1);
    }

    public static Type extractConstraintType(Class<? extends ConstraintValidator<?, ?>> validator) {
        return TypeHelper.extractConstraintValidatorTypeArgumentType(validator, 0);
    }

    public static Type extractConstraintValidatorTypeArgumentType(Class<? extends ConstraintValidator<?, ?>> validator, int typeArgumentIndex) {
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        Type constraintValidatorType = TypeHelper.resolveTypes(resolvedTypes, validator);
        Type type2 = ((ParameterizedType)constraintValidatorType).getActualTypeArguments()[typeArgumentIndex];
        if (type2 == null) {
            throw LOG.getNullIsAnInvalidTypeForAConstraintValidatorException();
        }
        if (type2 instanceof GenericArrayType) {
            type2 = TypeHelper.getArrayType(TypeHelper.getComponentType(type2));
        }
        while (resolvedTypes.containsKey(type2)) {
            type2 = (Type)resolvedTypes.get(type2);
        }
        return type2;
    }

    public static boolean isUnboundWildcard(Type type2) {
        if (!(type2 instanceof WildcardType)) {
            return false;
        }
        WildcardType wildcardType = (WildcardType)type2;
        return TypeHelper.isEmptyBounds(wildcardType.getUpperBounds()) && TypeHelper.isEmptyBounds(wildcardType.getLowerBounds());
    }

    private static Type resolveTypes(Map<Type, Type> resolvedTypes, Type type2) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            Type returnedType = TypeHelper.resolveTypeForClassAndHierarchy(resolvedTypes, clazz);
            if (returnedType != null) {
                return returnedType;
            }
        } else if (type2 instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type2;
            if (!(paramType.getRawType() instanceof Class)) {
                return null;
            }
            Class rawType = (Class)paramType.getRawType();
            TypeVariable<Class<T>>[] originalTypes = rawType.getTypeParameters();
            Type[] partiallyResolvedTypes = paramType.getActualTypeArguments();
            int nbrOfParams = originalTypes.length;
            for (int i = 0; i < nbrOfParams; ++i) {
                resolvedTypes.put(originalTypes[i], partiallyResolvedTypes[i]);
            }
            if (rawType.equals(ConstraintValidator.class)) {
                return type2;
            }
            Type returnedType = TypeHelper.resolveTypeForClassAndHierarchy(resolvedTypes, rawType);
            if (returnedType != null) {
                return returnedType;
            }
        }
        return null;
    }

    private static Type resolveTypeForClassAndHierarchy(Map<Type, Type> resolvedTypes, Class<?> clazz) {
        Type returnedType = TypeHelper.resolveTypes(resolvedTypes, clazz.getGenericSuperclass());
        if (returnedType != null) {
            return returnedType;
        }
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            returnedType = TypeHelper.resolveTypes(resolvedTypes, genericInterface);
            if (returnedType == null) continue;
            return returnedType;
        }
        return null;
    }

    private static void putPrimitiveSubtypes(Map<Class<?>, Set<Class<?>>> subtypesByPrimitive, Class<?> primitiveType, Class<?> ... directSubtypes) {
        HashSet subtypes = CollectionHelper.newHashSet();
        for (Class<?> directSubtype : directSubtypes) {
            subtypes.add(directSubtype);
            subtypes.addAll((Collection)subtypesByPrimitive.get(directSubtype));
        }
        subtypesByPrimitive.put(primitiveType, Collections.unmodifiableSet(subtypes));
    }

    private static boolean isClassAssignable(Class<?> supertype, Class<?> type2) {
        if (supertype.isPrimitive() && type2.isPrimitive()) {
            return SUBTYPES_BY_PRIMITIVE.get(supertype).contains(type2);
        }
        return supertype.isAssignableFrom(type2);
    }

    private static boolean isClassAssignableToWildcardType(Class<?> supertype, WildcardType type2) {
        for (Type upperBound : type2.getUpperBounds()) {
            if (TypeHelper.isAssignable(supertype, upperBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParameterizedTypeAssignable(ParameterizedType supertype, ParameterizedType type2) {
        Type[] typeArgs;
        Type rawType;
        Type rawSupertype = supertype.getRawType();
        if (!rawSupertype.equals(rawType = type2.getRawType())) {
            if (rawSupertype instanceof Class && rawType instanceof Class && !((Class)rawSupertype).isAssignableFrom((Class)rawType)) {
                return false;
            }
            return TypeHelper.isSuperAssignable(supertype, type2);
        }
        Type[] supertypeArgs = supertype.getActualTypeArguments();
        if (supertypeArgs.length != (typeArgs = type2.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < supertypeArgs.length; ++i) {
            Type supertypeArg = supertypeArgs[i];
            Type typeArg = typeArgs[i];
            if (!(supertypeArg instanceof WildcardType ? !TypeHelper.isWildcardTypeAssignable((WildcardType)supertypeArg, typeArg) : !supertypeArg.equals(typeArg))) continue;
            return false;
        }
        return true;
    }

    private static boolean isTypeVariableAssignable(Type supertype, TypeVariable<?> type2) {
        for (Type bound : type2.getBounds()) {
            if (!TypeHelper.isAssignable(supertype, bound)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildcardTypeAssignable(WildcardType supertype, Type type2) {
        for (Type upperBound : supertype.getUpperBounds()) {
            if (TypeHelper.isAssignable(upperBound, type2)) continue;
            return false;
        }
        for (Type lowerBound : supertype.getLowerBounds()) {
            if (TypeHelper.isAssignable(type2, lowerBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSuperAssignable(Type supertype, Type type2) {
        Type superclass = TypeHelper.getResolvedSuperclass(type2);
        if (superclass != null && TypeHelper.isAssignable(supertype, superclass)) {
            return true;
        }
        for (Type interphace : TypeHelper.getResolvedInterfaces(type2)) {
            if (!TypeHelper.isAssignable(supertype, interphace)) continue;
            return true;
        }
        return false;
    }

    private static boolean isReferenceType(Type type2) {
        return type2 == null || type2 instanceof Class || type2 instanceof ParameterizedType || type2 instanceof TypeVariable || type2 instanceof GenericArrayType || type2 instanceof WildcardType;
    }

    private static boolean isArraySupertype(Class<?> type2) {
        return Object.class.equals(type2) || Cloneable.class.equals(type2) || Serializable.class.equals(type2);
    }

    private static Type resolveTypeVariables(Type type2, Type subtype) {
        if (!(type2 instanceof ParameterizedType)) {
            return type2;
        }
        Map<Type, Type> actualTypeArgumentsByParameter = TypeHelper.getActualTypeArgumentsByParameter(type2, subtype);
        Class<?> rawType = TypeHelper.getErasedReferenceType(type2);
        return TypeHelper.parameterizeClass(rawType, actualTypeArgumentsByParameter);
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameter(Type ... types) {
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (Type type2 : types) {
            actualTypeArgumentsByParameter.putAll(TypeHelper.getActualTypeArgumentsByParameterInternal(type2));
        }
        return TypeHelper.normalize(actualTypeArgumentsByParameter);
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameterInternal(Type type2) {
        Type[] typeArguments;
        if (!(type2 instanceof ParameterizedType)) {
            return Collections.emptyMap();
        }
        TypeVariable<Class<?>>[] typeParameters2 = TypeHelper.getErasedReferenceType(type2).getTypeParameters();
        if (typeParameters2.length != (typeArguments = ((ParameterizedType)type2).getActualTypeArguments()).length) {
            throw new MalformedParameterizedTypeException();
        }
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (int i = 0; i < typeParameters2.length; ++i) {
            if (typeParameters2[i].equals(typeArguments[i])) continue;
            actualTypeArgumentsByParameter.put(typeParameters2[i], typeArguments[i]);
        }
        return actualTypeArgumentsByParameter;
    }

    private static ParameterizedType parameterizeClass(Class<?> type2, Map<Type, Type> actualTypeArgumentsByParameter) {
        return TypeHelper.parameterizeClassCapture(type2, actualTypeArgumentsByParameter);
    }

    private static <T> ParameterizedType parameterizeClassCapture(Class<T> type2, Map<Type, Type> actualTypeArgumentsByParameter) {
        TypeVariable<Class<T>>[] typeParameters2 = type2.getTypeParameters();
        Type[] actualTypeArguments = new Type[typeParameters2.length];
        for (int i = 0; i < typeParameters2.length; ++i) {
            TypeVariable<Class<T>> typeParameter = typeParameters2[i];
            Type actualTypeArgument = actualTypeArgumentsByParameter.get(typeParameter);
            if (actualTypeArgument == null) {
                throw LOG.getMissingActualTypeArgumentForTypeParameterException(typeParameter);
            }
            actualTypeArguments[i] = actualTypeArgument;
        }
        return TypeHelper.parameterizedType(TypeHelper.getErasedReferenceType(type2), actualTypeArguments);
    }

    private static <K, V> Map<K, V> normalize(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            while (map.containsKey(value)) {
                value = map.get(value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static boolean isEmptyBounds(Type[] bounds) {
        return bounds == null || bounds.length == 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]);
    }

    static {
        LOG = LoggerFactory.make(MethodHandles.lookup());
        HashMap<Class<?>, Set<Class<?>>> subtypesByPrimitive = CollectionHelper.newHashMap();
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Void.TYPE, new Class[0]);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Boolean.TYPE, new Class[0]);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Byte.TYPE, new Class[0]);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Character.TYPE, new Class[0]);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Short.TYPE, Byte.TYPE);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Integer.TYPE, Character.TYPE, Short.TYPE);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Long.TYPE, Integer.TYPE);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Float.TYPE, Long.TYPE);
        TypeHelper.putPrimitiveSubtypes(subtypesByPrimitive, Double.TYPE, Float.TYPE);
        SUBTYPES_BY_PRIMITIVE = Collections.unmodifiableMap(subtypesByPrimitive);
    }
}

