/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.context;

import java.security.AccessController;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextPermission;
import org.wildfly.common.context.Contextual;

public final class ContextManager<C extends Contextual<C>>
implements Supplier<C> {
    private final AtomicReference<Supplier<C>> globalDefaultSupplierRef = new AtomicReference();
    private final ConcurrentHashMap<ClassLoader, Supplier<C>> perClassLoaderDefault = new ConcurrentHashMap();
    private final Class<C> type;
    private final String name;
    private final ThreadLocal<State<C>> stateRef = ThreadLocal.withInitial(State::new);
    private final ContextPermission getPermission;

    public ContextManager(Class<C> type2) {
        this(type2, type2.getName());
    }

    public ContextManager(Class<C> type2, String name) {
        Assert.checkNotNullParam("type", type2);
        Assert.checkNotNullParam("name", name);
        Assert.checkNotEmptyParam("name", name);
        this.type = type2;
        this.name = name;
        this.getPermission = new ContextPermission(name, "get");
    }

    public C getGlobalDefault() {
        Supplier<C> globalDefault;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getGlobalDefault"));
        }
        return (C)((globalDefault = this.globalDefaultSupplierRef.get()) == null ? null : (Contextual)globalDefault.get());
    }

    public void setGlobalDefaultSupplier(Supplier<C> supplier) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setGlobalDefaultSupplier"));
        }
        this.globalDefaultSupplierRef.set(supplier);
    }

    public boolean setGlobalDefaultSupplierIfNotSet(Supplier<Supplier<C>> supplierSupplier) {
        AtomicReference<Supplier<C>> ref;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setGlobalDefaultSupplier"));
        }
        return (ref = this.globalDefaultSupplierRef).get() == null && ref.compareAndSet(null, supplierSupplier.get());
    }

    public void setGlobalDefault(C globalDefault) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getGlobalDefault"));
        }
        this.globalDefaultSupplierRef.set(globalDefault == null ? null : () -> globalDefault);
    }

    public C getClassLoaderDefault(ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getClassLoaderDefault"));
        }
        if (classLoader == null) {
            return null;
        }
        Supplier<C> supplier = this.perClassLoaderDefault.get(classLoader);
        return (C)(supplier == null ? null : (Contextual)supplier.get());
    }

    public void setClassLoaderDefaultSupplier(ClassLoader classLoader, Supplier<C> supplier) {
        Assert.checkNotNullParam("classLoader", classLoader);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setClassLoaderDefaultSupplier"));
        }
        if (supplier == null) {
            this.perClassLoaderDefault.remove(classLoader);
        } else {
            this.perClassLoaderDefault.put(classLoader, supplier);
        }
    }

    public void setClassLoaderDefault(ClassLoader classLoader, C classLoaderDefault) {
        Assert.checkNotNullParam("classLoader", classLoader);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setClassLoaderDefault"));
        }
        if (classLoaderDefault == null) {
            this.perClassLoaderDefault.remove(classLoader);
        } else {
            this.perClassLoaderDefault.put(classLoader, () -> classLoaderDefault);
        }
    }

    public C getThreadDefault() {
        Supplier defaultSupplier;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getThreadDefault"));
        }
        return (C)((defaultSupplier = this.stateRef.get().defaultSupplier) == null ? null : (Contextual)defaultSupplier.get());
    }

    public void setThreadDefaultSupplier(Supplier<C> supplier) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setThreadDefaultSupplier"));
        }
        this.stateRef.get().defaultSupplier = supplier;
    }

    public void setThreadDefault(C threadDefault) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setThreadDefault"));
        }
        this.stateRef.get().defaultSupplier = threadDefault == null ? null : () -> threadDefault;
    }

    @Override
    public C get() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.getPermission);
        }
        return this.getPrivileged();
    }

    public Supplier<C> getPrivilegedSupplier() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getPrivilegedSupplier"));
        }
        return this::getPrivileged;
    }

    private C getPrivileged() {
        Supplier<Object> supplier;
        State<C> state = this.stateRef.get();
        Contextual c = (Contextual)state.current;
        if (c != null) {
            return (C)c;
        }
        Thread currentThread = Thread.currentThread();
        SecurityManager sm = System.getSecurityManager();
        ClassLoader classLoader = sm != null ? AccessController.doPrivileged(currentThread::getContextClassLoader) : currentThread.getContextClassLoader();
        if (classLoader != null && (supplier = this.perClassLoaderDefault.get(classLoader)) != null && (c = (Contextual)supplier.get()) != null) {
            return (C)c;
        }
        supplier = state.defaultSupplier;
        if (supplier != null && (c = (Contextual)supplier.get()) != null) {
            return (C)c;
        }
        supplier = this.globalDefaultSupplierRef.get();
        return (C)(supplier != null ? (Contextual)supplier.get() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C getAndSetCurrent(Contextual<C> newVal) {
        Contextual cast = (Contextual)this.type.cast(newVal);
        State<C> state = this.stateRef.get();
        try {
            Contextual contextual = (Contextual)state.current;
            return (C)contextual;
        }
        finally {
            state.current = cast;
        }
    }

    void restoreCurrent(C oldVal) {
        this.stateRef.get().current = oldVal;
    }

    static class State<T> {
        T current;
        Supplier<T> defaultSupplier;

        State() {
        }
    }
}

