/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el;

import com.sun.el.ValueExpressionLiteral;
import com.sun.el.lang.ELSupport;
import com.sun.el.lang.ExpressionBuilder;
import com.sun.el.stream.StreamELResolver;
import com.sun.el.util.MessageFactory;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ExpressionFactoryImpl
extends ExpressionFactory {
    private Properties properties;
    private boolean isBackwardCompatible22;

    public ExpressionFactoryImpl() {
    }

    public ExpressionFactoryImpl(Properties properties2) {
        this.properties = properties2;
        this.isBackwardCompatible22 = "true".equals(this.getProperty("jakarta.el.bc2.2"));
    }

    @Override
    public Object coerceToType(Object obj, Class<?> type2) {
        try {
            return ELSupport.coerceToType(obj, type2, this.isBackwardCompatible22);
        }
        catch (IllegalArgumentException ex) {
            throw new ELException(ex);
        }
    }

    @Override
    public MethodExpression createMethodExpression(ELContext context, String expression, Class<?> expectedReturnType, Class<?>[] expectedParamTypes) {
        MethodExpression methodExpression = new ExpressionBuilder(expression, context).createMethodExpression(expectedReturnType, expectedParamTypes);
        if (expectedParamTypes == null && !methodExpression.isParametersProvided()) {
            throw new NullPointerException(MessageFactory.get("error.method.nullParms"));
        }
        return methodExpression;
    }

    @Override
    public ValueExpression createValueExpression(ELContext context, String expression, Class<?> expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        return new ExpressionBuilder(expression, context).createValueExpression(expectedType);
    }

    @Override
    public ValueExpression createValueExpression(Object instance, Class<?> expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        return new ValueExpressionLiteral(instance, expectedType);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    @Override
    public ELResolver getStreamELResolver() {
        return new StreamELResolver();
    }

    @Override
    public Map<String, Method> getInitFunctionMap() {
        return new HashMap<String, Method>();
    }
}

