/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.reflection.ReflectionUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static void writeFile(String fileName, String content) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            writer.write(content);
        }
    }

    public static String loadFile(String fileName) {
        return FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName, StandardCharsets.UTF_8);
    }

    public static String loadFile(Class<?> referencePoint, String fileName) {
        return FileUtils.loadFile(referencePoint, fileName, StandardCharsets.UTF_8);
    }

    public static String loadFile(String fileName, Charset charset) {
        return FileUtils.loadFile(ReflectionUtils.getCallerClass(), fileName, charset);
    }

    public static String loadFile(Class<?> referencePoint, String fileName, Charset charset) {
        String string;
        block10: {
            InputStream inputStream = referencePoint.getResourceAsStream(fileName);
            try {
                string = new Scanner(inputStream, charset).useDelimiter("\\A").next();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NullPointerException e) {
                    log.error("Resource {} not found in package {}", (Object)fileName, (Object)referencePoint.getPackageName());
                    throw e;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String loadFile(File file) {
        String string;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            string = new Scanner((InputStream)inputStream, StandardCharsets.UTF_8).useDelimiter("\\A").next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("File not found {}", (Object)file, (Object)e);
                throw e;
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }

    public static Optional<String> tryLoadFile(String fileName) {
        return FileUtils.tryLoadFile(ReflectionUtils.getCallerClass(), fileName, StandardCharsets.UTF_8);
    }

    public static Optional<String> tryLoadFile(Class<?> referencePoint, String fileName) {
        return FileUtils.tryLoadFile(referencePoint, fileName, StandardCharsets.UTF_8);
    }

    public static Optional<String> tryLoadFile(String fileName, Charset charset) {
        return FileUtils.tryLoadFile(ReflectionUtils.getCallerClass(), fileName, charset);
    }

    public static Optional<String> tryLoadFile(Class<?> referencePoint, String fileName, Charset charset) {
        Optional<String> optional;
        block10: {
            InputStream inputStream = referencePoint.getResourceAsStream(fileName);
            try {
                optional = Optional.ofNullable(new Scanner(inputStream, charset).useDelimiter("\\A").next());
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    public static Optional<String> tryLoadFile(File file) {
        Optional<String> optional;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            optional = Optional.ofNullable(new Scanner((InputStream)inputStream, StandardCharsets.UTF_8).useDelimiter("\\A").next());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return Optional.empty();
            }
        }
        ((InputStream)inputStream).close();
        return optional;
    }
}

