/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import io.fluxcapacitor.common.MemoizingBiFunction;
import io.fluxcapacitor.common.MemoizingFunction;
import io.fluxcapacitor.common.MemoizingSupplier;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ObjectUtils {
    private static final Predicate<Object> noOpPredicate = v -> true;
    private static final BiPredicate<Object, Object> noOpBiPredicate = (a, b) -> true;
    private static final AtomicInteger threadNumber = new AtomicInteger(1);

    public static <T> Predicate<T> noOpPredicate() {
        return noOpPredicate;
    }

    public static <T, U> BiPredicate<T, U> noOpBiPredicate() {
        return noOpBiPredicate;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <T> Stream<T> iterate(T seed, UnaryOperator<T> f, Predicate<T> breakCondition) {
        return StreamSupport.stream(new BreakingSpliterator<T>(Stream.iterate(seed, f), breakCondition), false);
    }

    public static <T> List<T> deduplicate(List<T> list) {
        return ObjectUtils.deduplicate(list, UnaryOperator.identity());
    }

    public static <T> List<T> deduplicate(List<T> list, Function<T, ?> idFunction) {
        return ObjectUtils.deduplicate(list, idFunction, false);
    }

    public static <T> List<T> deduplicate(List<T> list, Function<T, ?> idFunction, boolean keepFirst) {
        list = new ArrayList<T>(list);
        HashSet ids = new HashSet();
        if (keepFirst) {
            list.removeIf(t -> !ids.add(idFunction.apply(t)));
        } else {
            ListIterator<T> iterator2 = list.listIterator(list.size());
            while (iterator2.hasPrevious()) {
                if (ids.add(idFunction.apply(iterator2.previous()))) continue;
                iterator2.remove();
            }
        }
        return list;
    }

    public static Stream<?> asStream(Object value) {
        if (value == null) {
            return Stream.empty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream();
        }
        if (value instanceof Stream) {
            return (Stream)value;
        }
        if (value instanceof Optional) {
            return ((Optional)value).stream();
        }
        return Stream.of(value);
    }

    public static Consumer<Runnable> ifTrue(boolean check) {
        return check ? Runnable::run : r -> {};
    }

    public static Object forceThrow(Throwable error) {
        throw error;
    }

    public static <T> T safelyCall(Callable<T> callable) {
        return callable.call();
    }

    public static <T> Supplier<T> safelySupply(Callable<T> callable) {
        return () -> ObjectUtils.safelyCall(callable);
    }

    public static Runnable asRunnable(Callable<?> callable) {
        return () -> ObjectUtils.safelyCall(callable);
    }

    public static byte[] getBytes(ByteBuffer buffer) {
        buffer = buffer.duplicate();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    public static Throwable unwrapException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof CompletionException || e instanceof ExecutionException) {
            return ObjectUtils.unwrapException(e.getCause());
        }
        return e;
    }

    public static Properties asProperties(String content) {
        Properties result = new Properties();
        result.load(new StringReader(content));
        return result;
    }

    public static Properties copyOf(Properties properties2) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)properties2);
        return result;
    }

    public static Properties merge(Properties a, Properties b) {
        Properties result = ObjectUtils.copyOf(a);
        result.putAll((Map<?, ?>)b);
        return result;
    }

    public static <T> MemoizingSupplier<T> memoize(Supplier<T> supplier) {
        MemoizingSupplier<T> memoizingSupplier;
        if (supplier instanceof MemoizingSupplier) {
            MemoizingSupplier existing = (MemoizingSupplier)supplier;
            memoizingSupplier = existing;
        } else {
            memoizingSupplier = new MemoizingSupplier<T>(supplier);
        }
        return memoizingSupplier;
    }

    public static <K, V> MemoizingFunction<K, V> memoize(Function<K, V> supplier) {
        MemoizingFunction<K, V> memoizingFunction;
        if (supplier instanceof MemoizingFunction) {
            MemoizingFunction existing = (MemoizingFunction)supplier;
            memoizingFunction = existing;
        } else {
            memoizingFunction = new MemoizingFunction<K, V>(supplier);
        }
        return memoizingFunction;
    }

    public static <T, U, R> MemoizingBiFunction<T, U, R> memoize(BiFunction<T, U, R> supplier) {
        MemoizingBiFunction<T, U, R> memoizingBiFunction;
        if (supplier instanceof MemoizingBiFunction) {
            MemoizingBiFunction existing = (MemoizingBiFunction)supplier;
            memoizingBiFunction = existing;
        } else {
            memoizingBiFunction = new MemoizingBiFunction<T, U, R>(supplier);
        }
        return memoizingBiFunction;
    }

    public static String newThreadName(String prefix) {
        return prefix + "-" + threadNumber.getAndIncrement();
    }

    public static ThreadFactory newThreadFactory(String prefix) {
        return new PrefixedThreadFactory(prefix);
    }

    public static ExecutorService newNamedWorkStealingPool(int parallelism, String prefix) {
        return new ForkJoinPool(parallelism, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(prefix + "-pool-" + worker.getPoolIndex());
            return worker;
        }, null, true);
    }

    private static class BreakingSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Iterator<T> delegate;
        private final Predicate<T> breakCondition;
        private boolean stopped;

        private BreakingSpliterator(Stream<T> delegate, Predicate<T> breakCondition) {
            super(Long.MAX_VALUE, 0);
            this.delegate = delegate.iterator();
            this.breakCondition = breakCondition;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.stopped) {
                return false;
            }
            T value = this.delegate.next();
            if (this.breakCondition.test(value)) {
                this.stopped = true;
            }
            action.accept(value);
            return true;
        }
    }

    private static class PrefixedThreadFactory
    implements ThreadFactory {
        private static final Map<String, AtomicInteger> poolCount = new ConcurrentHashMap<String, AtomicInteger>();
        private final ThreadGroup group = Thread.currentThread().getThreadGroup();
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public PrefixedThreadFactory(String poolPrefix) {
            this.namePrefix = poolPrefix + "-pool-" + poolCount.computeIfAbsent(poolPrefix, k -> new AtomicInteger(1)).getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable task) {
            Thread t = new Thread(this.group, task, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

