/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.keyvalue;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;

public final class StoreValuesAndWait
extends Command {
    private final List<KeyValuePair> values;

    @Override
    public Guarantee getGuarantee() {
        return Guarantee.STORED;
    }

    @Override
    public String routingKey() {
        return this.values.get(0).getKey();
    }

    public String toString() {
        return "StoreValuesAndWait of size " + this.values.size();
    }

    @Override
    public Object toMetric() {
        return new Metric(this.values.stream().map(KeyValuePair::getKey).collect(Collectors.toList()), this.values.size());
    }

    @ConstructorProperties(value={"values"})
    public StoreValuesAndWait(List<KeyValuePair> values2) {
        this.values = values2;
    }

    public List<KeyValuePair> getValues() {
        return this.values;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoreValuesAndWait)) {
            return false;
        }
        StoreValuesAndWait other = (StoreValuesAndWait)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<KeyValuePair> this$values = this.getValues();
        List<KeyValuePair> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StoreValuesAndWait;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<KeyValuePair> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public static final class Metric {
        private final List<String> keys;
        private final int size;

        @ConstructorProperties(value={"keys", "size"})
        public Metric(List<String> keys2, int size) {
            this.keys = keys2;
            this.size = size;
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            List<String> this$keys = this.getKeys();
            List<String> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            List<String> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        public String toString() {
            return "StoreValuesAndWait.Metric(keys=" + String.valueOf(this.getKeys()) + ", size=" + this.getSize() + ")";
        }
    }
}

