/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.search.DocumentUpdate;
import java.beans.ConstructorProperties;
import java.util.Collection;

public final class BulkUpdateDocuments
extends Command {
    private final Collection<DocumentUpdate> updates;
    private final Guarantee guarantee;

    @JsonIgnore
    public int getSize() {
        return this.updates.size();
    }

    public String toString() {
        return "BulkUpdateDocuments of length " + this.updates.size();
    }

    @Override
    public Object toMetric() {
        return new Metric(this.updates.size(), this.guarantee);
    }

    @Override
    public String routingKey() {
        return this.updates.stream().map(DocumentUpdate::getId).findFirst().orElse(null);
    }

    @ConstructorProperties(value={"updates", "guarantee"})
    public BulkUpdateDocuments(Collection<DocumentUpdate> updates, Guarantee guarantee) {
        this.updates = updates;
        this.guarantee = guarantee;
    }

    public Collection<DocumentUpdate> getUpdates() {
        return this.updates;
    }

    @Override
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkUpdateDocuments)) {
            return false;
        }
        BulkUpdateDocuments other = (BulkUpdateDocuments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Collection<DocumentUpdate> this$updates = this.getUpdates();
        Collection<DocumentUpdate> other$updates = other.getUpdates();
        if (this$updates == null ? other$updates != null : !((Object)this$updates).equals(other$updates)) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BulkUpdateDocuments;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Collection<DocumentUpdate> $updates = this.getUpdates();
        result = result * 59 + ($updates == null ? 43 : ((Object)$updates).hashCode());
        Guarantee $guarantee = this.getGuarantee();
        result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result;
    }

    public static final class Metric {
        private final int size;
        private final Guarantee guarantee;

        @ConstructorProperties(value={"size", "guarantee"})
        public Metric(int size, Guarantee guarantee) {
            this.size = size;
            this.guarantee = guarantee;
        }

        public int getSize() {
            return this.size;
        }

        public Guarantee getGuarantee() {
            return this.guarantee;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metric)) {
                return false;
            }
            Metric other = (Metric)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            Guarantee this$guarantee = this.getGuarantee();
            Guarantee other$guarantee = other.getGuarantee();
            return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            Guarantee $guarantee = this.getGuarantee();
            result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
            return result;
        }

        public String toString() {
            return "BulkUpdateDocuments.Metric(size=" + this.getSize() + ", guarantee=" + String.valueOf((Object)this.getGuarantee()) + ")";
        }
    }
}

