/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import java.beans.ConstructorProperties;
import java.util.Comparator;
import lombok.NonNull;

public final class FacetEntry
implements Comparable<FacetEntry> {
    private static final Comparator<FacetEntry> comparator = Comparator.comparing(FacetEntry::getName).thenComparing(FacetEntry::getValue);
    @NonNull
    private final String name;
    @NonNull
    private final String value;

    @Override
    public int compareTo(@NonNull FacetEntry o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return comparator.compare(this, o);
    }

    @ConstructorProperties(value={"name", "value"})
    public FacetEntry(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.name = name;
        this.value = value;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FacetEntry)) {
            return false;
        }
        FacetEntry other = (FacetEntry)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "FacetEntry(name=" + this.getName() + ", value=" + this.getValue() + ")";
    }
}

